/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.time.ZonedDateTime;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class ZonedDateTimeVersionSupport
implements VersionSupport<ZonedDateTime> {
    public static final ZonedDateTimeVersionSupport INSTANCE = new ZonedDateTimeVersionSupport();

    @Override
    public ZonedDateTime seed(SharedSessionContractImplementor session) {
        return ZonedDateTime.now();
    }

    @Override
    public ZonedDateTime next(ZonedDateTime current, SharedSessionContractImplementor session) {
        return ZonedDateTime.now();
    }

    @Override
    public String toLoggableString(Object value) {
        return StandardSpiBasicTypes.ZONED_DATE_TIME.toLoggableString(value);
    }

    @Override
    public boolean isEqual(ZonedDateTime x, ZonedDateTime y) throws HibernateException {
        return StandardSpiBasicTypes.ZONED_DATE_TIME.areEqual(x, y);
    }
}

