/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.metamodel.model.relational.internal.ColumnMappingImpl;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.Table;

public class ColumnMappingsImpl
implements ForeignKey.ColumnMappings {
    private final Table referringTable;
    private final Table targetTable;
    private final List<ForeignKey.ColumnMappings.ColumnMapping> columnMappings;

    public ColumnMappingsImpl(Table referringTable, Table targetTable, List<ForeignKey.ColumnMappings.ColumnMapping> columnMappings) {
        this.referringTable = referringTable;
        this.targetTable = targetTable;
        this.columnMappings = columnMappings;
    }

    public ColumnMappingsImpl(Table referringTable, Table targetTable, List<Column> referringColumns, List<Column> targetColumns) {
        this(referringTable, targetTable, ColumnMappingsImpl.buildColumnMappings(referringColumns, targetColumns));
    }

    private static List<ForeignKey.ColumnMappings.ColumnMapping> buildColumnMappings(List<Column> referringColumns, List<Column> targetColumns) {
        assert (referringColumns.size() == targetColumns.size());
        ArrayList<ForeignKey.ColumnMappings.ColumnMapping> mappings = new ArrayList<ForeignKey.ColumnMappings.ColumnMapping>();
        for (int i = 0; i < referringColumns.size(); ++i) {
            mappings.add(new ColumnMappingImpl(referringColumns.get(i), targetColumns.get(i)));
        }
        return mappings;
    }

    @Override
    public Table getReferringTable() {
        return this.referringTable;
    }

    @Override
    public Table getTargetTable() {
        return this.targetTable;
    }

    @Override
    public List<ForeignKey.ColumnMappings.ColumnMapping> getColumnMappings() {
        return this.columnMappings;
    }

    @Override
    public Column findReferringColumn(Column targetColumn) {
        for (ForeignKey.ColumnMappings.ColumnMapping columnMapping : this.columnMappings) {
            if (columnMapping.getTargetColumn() != targetColumn) continue;
            return columnMapping.getReferringColumn();
        }
        throw new IllegalArgumentException(targetColumn + " is not a know targetColumn for this ForeignKey " + this.toString());
    }

    private List<PhysicalColumn> getColumns(Function<ForeignKey.ColumnMappings.ColumnMapping, PhysicalColumn> mapper) {
        return this.columnMappings.stream().map(mapper).collect(Collectors.toList());
    }
}

