/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.metamodel.model.relational.spi.AuxiliaryDatabaseObject;
import org.hibernate.metamodel.model.relational.spi.DatabaseModel;
import org.hibernate.metamodel.model.relational.spi.Namespace;

public class DatabaseModelImpl
implements DatabaseModel {
    private final JdbcEnvironment getJdbcEnvironment;
    private Namespace defautlNamespace;
    private List<AuxiliaryDatabaseObject> auxiliaryDatabaseObjects;
    private final List<Namespace> namespaces = new ArrayList<Namespace>();
    private List<InitCommand> initCommands = new ArrayList<InitCommand>();

    public DatabaseModelImpl(JdbcEnvironment getJdbcEnvironment) {
        this.getJdbcEnvironment = getJdbcEnvironment;
    }

    @Override
    public Collection<Namespace> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public Namespace getDefaultNamespace() {
        return this.defautlNamespace;
    }

    @Override
    public JdbcEnvironment getJdbcEnvironment() {
        return this.getJdbcEnvironment;
    }

    @Override
    public Collection<AuxiliaryDatabaseObject> getAuxiliaryDatabaseObjects() {
        if (this.auxiliaryDatabaseObjects == null) {
            return Collections.emptyList();
        }
        return this.auxiliaryDatabaseObjects;
    }

    @Override
    public Collection<InitCommand> getInitCommands() {
        return this.initCommands;
    }

    @Override
    public void addInitCommand(InitCommand initCommand) {
        this.initCommands.add(initCommand);
    }

    public void addNamespace(Namespace namespace) {
        this.namespaces.add(namespace);
    }

    public void setDefaultNamespace(Namespace namespace) {
        this.defautlNamespace = namespace;
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        if (this.auxiliaryDatabaseObjects == null) {
            this.auxiliaryDatabaseObjects = new ArrayList<AuxiliaryDatabaseObject>();
        }
        this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
    }
}

