/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.metamodel.model.relational.spi.Namespace;
import org.hibernate.metamodel.model.relational.spi.Sequence;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.NamespaceName;
import org.jboss.logging.Logger;

public class NamespaceImpl
implements Namespace {
    private static final Logger log = Logger.getLogger(NamespaceImpl.class);
    private final NamespaceName name;
    private List<Table> tables;
    private List<Sequence> sequences;

    public NamespaceImpl(Identifier catalogName, Identifier schemaName) {
        this.name = new NamespaceName(catalogName, schemaName);
    }

    @Override
    public Identifier getCatalogName() {
        return this.name.getCatalog();
    }

    @Override
    public Identifier getSchemaName() {
        return this.name.getSchema();
    }

    @Override
    public NamespaceName getName() {
        return this.name;
    }

    @Override
    public Collection<Table> getTables() {
        return this.tables == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.tables);
    }

    @Override
    public Table getTable(UUID tableUid) {
        for (Table table : this.tables) {
            if (!tableUid.equals(table.getUid())) continue;
            return table;
        }
        throw new HibernateException("Could not locate table in namespace [" + this + "] by UUID = " + tableUid);
    }

    @Override
    public Collection<Sequence> getSequences() {
        return this.sequences == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.sequences);
    }

    public void addTable(Table table) {
        log.debugf("Registering Table [%s] with namespace [%s]", (Object)table, (Object)this);
        if (this.tables == null) {
            this.tables = new ArrayList<Table>();
        }
        this.tables.add(table);
    }

    public String toString() {
        return String.format(Locale.ROOT, "Namespace[catalogName=%s, schemaName=%s]", this.name.getCatalog(), this.name.getSchema());
    }

    public void addSequence(Sequence sequence) {
        log.debugf("Registering Sequence [%s] with namespace [%s]", (Object)sequence, (Object)this);
        if (this.sequences == null) {
            this.sequences = new ArrayList<Sequence>();
        }
        this.sequences.add(sequence);
    }
}

