/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.spi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.hibernate.metamodel.model.relational.internal.InflightTable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.metamodel.model.relational.spi.PrimaryKey;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.metamodel.model.relational.spi.UniqueKey;
import org.hibernate.naming.Identifier;

public abstract class AbstractTable
implements InflightTable {
    private final UUID uuid;
    private final boolean isAbstract;
    private PrimaryKey primaryKey = null;
    private Set<ForeignKey> foreignKeys = new HashSet<ForeignKey>();
    private Set<UniqueKey> uniqueKeys = new HashSet<UniqueKey>();
    private final Map<String, Column> columnMap = new TreeMap<String, Column>(String.CASE_INSENSITIVE_ORDER);

    public AbstractTable(UUID uuid, boolean isAbstract) {
        this.uuid = uuid;
        this.isAbstract = isAbstract;
    }

    @Override
    public UUID getUid() {
        return this.uuid;
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public void addColumn(Column column) {
        this.columnMap.put(column.getExpression(), column);
    }

    @Override
    public Column getColumn(String name) {
        return this.columnMap.get(name);
    }

    @Override
    public Collection<Column> getColumns() {
        return this.columnMap.values();
    }

    @Override
    public Collection<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public Collection<UniqueKey> getUniqueKeys() {
        return this.uniqueKeys;
    }

    @Override
    public ForeignKey createForeignKey(String name, boolean export, String keyDefinition, boolean cascadeDeleteEnabled, boolean isReferenceToPrimaryKey, Table targetTable, ForeignKey.ColumnMappings columnMappings) {
        ForeignKey foreignKey = new ForeignKey(name, export, keyDefinition, cascadeDeleteEnabled, isReferenceToPrimaryKey, this, targetTable, columnMappings);
        this.foreignKeys.add(foreignKey);
        return foreignKey;
    }

    @Override
    public UniqueKey createUniqueKey(String name) {
        UniqueKey uniqueKey = new UniqueKey(Identifier.toIdentifier(name), this);
        this.uniqueKeys.add(uniqueKey);
        return uniqueKey;
    }

    @Override
    public void addPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public boolean hasPrimaryKey() {
        return this.primaryKey != null;
    }
}

