/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.spi;

import java.util.Collection;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.metamodel.model.relational.spi.AuxiliaryDatabaseObject;
import org.hibernate.metamodel.model.relational.spi.Namespace;

public interface DatabaseModel {
    public Collection<Namespace> getNamespaces();

    public Namespace getDefaultNamespace();

    public JdbcEnvironment getJdbcEnvironment();

    public Collection<AuxiliaryDatabaseObject> getAuxiliaryDatabaseObjects();

    public Collection<InitCommand> getInitCommands();

    public void addInitCommand(InitCommand var1);

    default public Namespace getNamespace(String catalogName, String schemaName) {
        boolean schemasMatch;
        if (catalogName == null && schemaName == null) {
            return this.getDefaultNamespace();
        }
        boolean catalogsMatch = this.getDefaultNamespace().getCatalogName() != null && Objects.equals(catalogName, this.getDefaultNamespace().getCatalogName().getText());
        boolean bl = schemasMatch = this.getDefaultNamespace().getSchemaName() != null && Objects.equals(schemaName, this.getDefaultNamespace().getSchemaName().getText());
        if (catalogsMatch && schemasMatch) {
            return this.getDefaultNamespace();
        }
        for (Namespace namespace : this.getNamespaces()) {
            if (catalogName != null && (namespace.getCatalogName() == null || !catalogName.equals(namespace.getCatalogName().getCanonicalName())) || schemaName == null || namespace.getSchemaName() == null || !schemaName.equals(namespace.getSchemaName().getCanonicalName())) continue;
            return namespace;
        }
        throw new HibernateException("Could not locate database namespace [catalog=" + catalogName + ", schema=" + schemaName + "]");
    }
}

