/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.spi;

import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Size;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class DerivedColumn
implements Column {
    private final Table table;
    private final String expression;
    private final TypeConfiguration typeConfiguration;
    private SqlTypeDescriptor sqlTypeDescriptor;
    private BasicJavaDescriptor javaTypeDescriptor;
    private SqlExpressableType sqlExpressableType;
    private final boolean isInsertable;
    private final boolean isUpdatable;

    public DerivedColumn(Table table, String expression, SqlTypeDescriptor sqlTypeDescriptor, TypeConfiguration typeConfiguration, BasicJavaDescriptor javaTypeDescriptor, boolean insertable, boolean updatable) {
        this.table = table;
        this.expression = expression;
        this.sqlTypeDescriptor = sqlTypeDescriptor;
        this.typeConfiguration = typeConfiguration;
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.isInsertable = insertable;
        this.isUpdatable = updatable;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public Table getSourceTable() {
        return this.table;
    }

    @Override
    public String toLoggableString() {
        return "DerivedColumn( " + this.expression + ")";
    }

    public String toString() {
        return this.toLoggableString();
    }

    @Override
    public String render(String identificationVariable) {
        return this.expression;
    }

    @Override
    public String render() {
        return this.expression;
    }

    @Override
    public SqlTypeDescriptor getSqlTypeDescriptor() {
        return this.sqlTypeDescriptor;
    }

    @Override
    public BasicJavaDescriptor getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    @Override
    public SqlExpressableType getExpressableType() {
        if (this.sqlExpressableType == null) {
            this.sqlExpressableType = this.getSqlTypeDescriptor().getSqlExpressableType(this.getJavaTypeDescriptor(), this.typeConfiguration);
        }
        return this.sqlExpressableType;
    }

    @Override
    public Size getSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInsertable() {
        return this.isInsertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    @Override
    public Column clone(boolean isInsertable, boolean isUpdatable) {
        return new DerivedColumn(this.table, this.expression, this.sqlTypeDescriptor, this.typeConfiguration, this.javaTypeDescriptor, isInsertable, isUpdatable);
    }
}

