/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.id.uuid.LocalObjectUuidHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.streams.GenericArrayCollector;
import org.hibernate.mapping.Constraint;
import org.hibernate.metamodel.model.relational.internal.ColumnMappingImpl;
import org.hibernate.metamodel.model.relational.internal.ColumnMappingsImpl;
import org.hibernate.metamodel.model.relational.internal.InflightTable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Exportable;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.PhysicalTable;
import org.hibernate.metamodel.model.relational.spi.Table;

public class ForeignKey
implements Exportable {
    private final String name;
    private final Table referringTable;
    private final Table targetTable;
    private final ColumnMappings columnMappings;
    private final boolean cascadeDeleteEnabled;
    private final boolean isReferenceToPrimaryKey;
    private final boolean export;
    private final String keyDefinition;

    public ForeignKey(String name, boolean export, String keyDefinition, boolean cascadeDeleteEnabled, boolean isReferenceToPrimaryKey, Table referringTable, Table targetTable, ColumnMappings columnMappings) {
        this.name = name;
        this.export = export;
        this.keyDefinition = keyDefinition;
        this.cascadeDeleteEnabled = cascadeDeleteEnabled;
        this.isReferenceToPrimaryKey = isReferenceToPrimaryKey;
        this.referringTable = referringTable;
        this.targetTable = targetTable;
        this.columnMappings = columnMappings;
    }

    public String getName() {
        return this.name;
    }

    public Table getReferringTable() {
        return this.referringTable;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public ColumnMappings getColumnMappings() {
        return this.columnMappings;
    }

    public boolean isExportationEnabled() {
        return this.export;
    }

    @Override
    public String getExportIdentifier() {
        return StringHelper.qualify(((ExportableTable)this.referringTable).getExportIdentifier(), "FK-" + this.getName());
    }

    public boolean isReferenceToPrimaryKey() {
        return this.isReferenceToPrimaryKey;
    }

    public String getKeyDefinition() {
        return this.keyDefinition;
    }

    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public Column resolveReferringFromTargetColumn(Column targetColumn) {
        for (ColumnMappings.ColumnMapping columnMapping : this.getColumnMappings().getColumnMappings()) {
            if (!columnMapping.getTargetColumn().equals(targetColumn)) continue;
            return columnMapping.getReferringColumn();
        }
        return null;
    }

    public Column resolveTargetFromReferringColumn(Column referringColumn) {
        for (ColumnMappings.ColumnMapping columnMapping : this.getColumnMappings().getColumnMappings()) {
            if (!columnMapping.getReferringColumn().equals(referringColumn)) continue;
            return columnMapping.getTargetColumn();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForeignKey that = (ForeignKey)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.referringTable, that.referringTable);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.referringTable);
    }

    public static class Builder {
        private final String name;
        private final boolean export;
        private final boolean referenceToPrimaryKey;
        private final boolean cascadeDeletes;
        private final String explicitDefinition;
        private final Table referringTable;
        private final Table targetTable;
        private final List<ColumnMappings.ColumnMapping> columnMappings = new ArrayList<ColumnMappings.ColumnMapping>();

        public Builder(String name, boolean export, boolean referenceToPrimaryKey, boolean cascadeDeletes, String explicitDefinition, Table referringTable, Table targetTable) {
            this.name = name;
            this.export = export;
            this.referenceToPrimaryKey = referenceToPrimaryKey;
            this.cascadeDeletes = cascadeDeletes;
            this.explicitDefinition = explicitDefinition;
            this.referringTable = referringTable;
            this.targetTable = targetTable;
        }

        public ForeignKey build() {
            String name = StringHelper.isEmpty(this.name) ? Builder.generateSyntheticName(this.referringTable, this.columnMappings, this.export) : this.name;
            return ((InflightTable)this.referringTable).createForeignKey(name, this.export, this.explicitDefinition, this.cascadeDeletes, this.referenceToPrimaryKey, this.targetTable, new ColumnMappingsImpl(this.referringTable, this.targetTable, this.columnMappings));
        }

        private static String generateSyntheticName(Table referringTable, List<ColumnMappings.ColumnMapping> columnMappings, boolean export) {
            if (!export || !(referringTable instanceof PhysicalTable)) {
                return LocalObjectUuidHelper.generateLocalObjectUuid();
            }
            StringBuilder sb = new StringBuilder("table`" + ((PhysicalTable)referringTable).getTableName().getText() + "`");
            Column[] alphabeticalColumns = (Column[])columnMappings.stream().map(ColumnMappings.ColumnMapping::getReferringColumn).collect(GenericArrayCollector.forType(Column.class));
            Arrays.sort(alphabeticalColumns, Column.COLUMN_COMPARATOR);
            for (Column column : alphabeticalColumns) {
                String columnName = column == null ? "" : column.getExpression();
                sb.append("column`").append(columnName).append("`");
            }
            return "FK_" + Constraint.hashedName(sb.toString());
        }

        public void addColumnMapping(Column referringColumn, Column targetColumn) {
            assert (referringColumn.getSourceTable() == this.referringTable);
            assert (targetColumn.getSourceTable() == this.targetTable);
            this.columnMappings.add(new ColumnMappingImpl(referringColumn, targetColumn));
        }
    }

    public static interface ColumnMappings {
        public Table getReferringTable();

        public Table getTargetTable();

        public List<ColumnMapping> getColumnMappings();

        default public List<Column> getReferringColumns() {
            return this.getColumnMappings().stream().map(ColumnMapping::getReferringColumn).collect(Collectors.toList());
        }

        default public List<Column> getTargetColumns() {
            return this.getColumnMappings().stream().map(ColumnMapping::getTargetColumn).collect(Collectors.toList());
        }

        public Column findReferringColumn(Column var1);

        public static interface ColumnMapping {
            public Column getReferringColumn();

            public Column getTargetColumn();
        }
    }
}

