/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Exportable;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.naming.Identifier;

public class Index
implements Exportable {
    private final ExportableTable table;
    private final List<PhysicalColumn> columns = new ArrayList<PhysicalColumn>();
    private final Map<Column, String> columnOrder = new HashMap<Column, String>();
    private final Identifier name;

    public Index(Identifier name, ExportableTable table) {
        this.name = name;
        this.table = table;
    }

    public void addColumn(PhysicalColumn column) {
        this.columns.add(column);
    }

    public Identifier getName() {
        return this.name;
    }

    public List<PhysicalColumn> getColumns() {
        return this.columns;
    }

    public ExportableTable getTable() {
        return this.table;
    }

    @Override
    public String getExportIdentifier() {
        return StringHelper.qualify(this.getTable().getExportIdentifier(), "IDX-" + this.getName().render());
    }

    public String getColumnOrderMap(Column column) {
        return this.columnOrder.get(column);
    }

    public void addColumnOrder(Column column, String order) {
        this.columnOrder.putIfAbsent(column, order);
    }
}

