/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.spi;

import java.util.Objects;
import java.util.function.Supplier;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Size;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.naming.Identifier;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class PhysicalColumn
implements Column {
    private final Table table;
    private final Identifier name;
    private final Supplier<SqlTypeDescriptor> sqlTypeDescriptorAccess;
    private Size size;
    private String sqlType;
    private Supplier<BasicJavaDescriptor> javaTypeDescriptorAccess;
    private SqlExpressableType sqlExpressableType;
    private final String defaultValue;
    private String checkConstraint;
    private final boolean isNullable;
    private final boolean isUnique;
    private final boolean isInsertable;
    private final boolean isUpdatable;
    private final String comment;
    private final TypeConfiguration typeConfiguration;
    private Dialect dialect;

    public PhysicalColumn(Table table, Identifier name, Supplier<SqlTypeDescriptor> sqlTypeDescriptorAccess, Supplier<BasicJavaDescriptor> javaTypeDescriptorAccess, String defaultValue, String sqlType, boolean isNullable, boolean isUnique, TypeConfiguration typeConfiguration) {
        this(table, name, sqlTypeDescriptorAccess, javaTypeDescriptorAccess, defaultValue, sqlType, isNullable, isUnique, null, typeConfiguration, true, true);
    }

    public PhysicalColumn(Table table, Identifier name, Supplier<SqlTypeDescriptor> sqlTypeDescriptorAccess, Supplier<BasicJavaDescriptor> javaTypeDescriptorAccess, String defaultValue, String sqlType, boolean isNullable, boolean isUnique, String comment, TypeConfiguration typeConfiguration, boolean insertable, boolean updatable) {
        this.table = table;
        this.name = name;
        this.sqlTypeDescriptorAccess = sqlTypeDescriptorAccess;
        this.javaTypeDescriptorAccess = javaTypeDescriptorAccess;
        this.defaultValue = defaultValue;
        this.sqlType = sqlType;
        this.isNullable = isNullable;
        this.isUnique = isUnique;
        this.comment = comment;
        this.typeConfiguration = typeConfiguration;
        this.isInsertable = insertable;
        this.isUpdatable = updatable;
    }

    public Identifier getName() {
        return this.name;
    }

    @Override
    public Table getSourceTable() {
        return this.table;
    }

    @Override
    public String getExpression() {
        return this.name.getText();
    }

    @Override
    public SqlExpressableType getExpressableType() {
        if (this.sqlExpressableType == null) {
            this.sqlExpressableType = this.getSqlTypeDescriptor().getSqlExpressableType(this.getJavaTypeDescriptor(), this.typeConfiguration);
        }
        return this.sqlExpressableType;
    }

    @Override
    public SqlTypeDescriptor getSqlTypeDescriptor() {
        return this.sqlTypeDescriptorAccess.get();
    }

    @Override
    public BasicJavaDescriptor getJavaTypeDescriptor() {
        return this.javaTypeDescriptorAccess.get();
    }

    public Supplier<SqlTypeDescriptor> getSqlTypeDescriptorAccess() {
        return this.sqlTypeDescriptorAccess;
    }

    public Supplier<BasicJavaDescriptor> getJavaTypeDescriptorAccess() {
        return this.javaTypeDescriptorAccess;
    }

    @Override
    public String render(String identificationVariable) {
        if (this.dialect == null) {
            this.dialect = this.typeConfiguration.getSessionFactory().getJdbcServices().getDialect();
        }
        if (identificationVariable != null) {
            return identificationVariable + '.' + this.render(this.dialect);
        }
        return this.render(this.dialect);
    }

    @Override
    public String render() {
        if (this.dialect == null) {
            this.dialect = this.typeConfiguration.getSessionFactory().getJdbcServices().getDialect();
        }
        return this.render(this.dialect);
    }

    private String render(Dialect dialect) {
        return this.name.render(dialect);
    }

    public String toString() {
        return "PhysicalColumn(" + this.table.getTableExpression() + " : " + this.name + ")";
    }

    @Override
    public String toLoggableString() {
        return this.toString();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isInsertable() {
        return this.isInsertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public void setCheckConstraint(String checkConstraint) {
        this.checkConstraint = checkConstraint;
    }

    public String getSqlTypeName() {
        return this.sqlType;
    }

    public String getCheckConstraint() {
        return this.checkConstraint;
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalColumn that = (PhysicalColumn)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.name);
    }

    @Override
    public Column clone(boolean isInsertable, boolean isUpdatable) {
        return new PhysicalColumn(this.table, this.name, this.sqlTypeDescriptorAccess, this.javaTypeDescriptorAccess, this.defaultValue, this.sqlType, this.isNullable, this.isUnique, this.comment, this.typeConfiguration, isInsertable, isUpdatable);
    }
}

