/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.metamodel.model.relational.spi.AbstractTable;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.Index;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.PhysicalNamingStrategy;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.QualifiedTableName;

public class PhysicalTable
extends AbstractTable
implements ExportableTable {
    private final QualifiedTableName qualifiedTableName;
    private boolean primaryKeyIdentity;
    private String comment;
    private List<String> checkConstraints = new ArrayList<String>();
    private List<Index> indexes = new ArrayList<Index>();
    private List<InitCommand> initCommands = new ArrayList<InitCommand>();

    public PhysicalTable(UUID uuid, Identifier logicalCatalogName, Identifier logicalSchemaName, Identifier logicalTableName, boolean isAbstract, String comment, PhysicalNamingStrategy namingStrategy, JdbcEnvironment jdbcEnvironment) {
        this(uuid, new QualifiedTableName(namingStrategy.toPhysicalCatalogName(logicalCatalogName, jdbcEnvironment), namingStrategy.toPhysicalSchemaName(logicalSchemaName, jdbcEnvironment), namingStrategy.toPhysicalTableName(logicalTableName, jdbcEnvironment)), isAbstract, comment);
    }

    public PhysicalTable(UUID uuid, QualifiedTableName physicalQualifiedName, boolean isAbstract, String comment) {
        super(uuid, isAbstract);
        this.qualifiedTableName = physicalQualifiedName;
        this.comment = comment;
    }

    @Override
    public Identifier getCatalogName() {
        return this.qualifiedTableName.getCatalogName();
    }

    @Override
    public Identifier getSchemaName() {
        return this.qualifiedTableName.getSchemaName();
    }

    @Override
    public Identifier getTableName() {
        return this.qualifiedTableName.getTableName();
    }

    @Override
    public QualifiedTableName getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    @Override
    public String getTableExpression() {
        return this.getTableName().getText();
    }

    @Override
    public String render(Dialect dialect, JdbcEnvironment jdbcEnvironment) {
        return jdbcEnvironment.getQualifiedObjectNameFormatter().format(this.getQualifiedTableName(), dialect);
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    public String toString() {
        return "PhysicalTable(" + this.getTableName() + ")";
    }

    @Override
    public String getExportIdentifier() {
        return PhysicalTable.qualify(this.render(this.getCatalogName()), this.render(this.getSchemaName()), this.getTableName().render());
    }

    @Deprecated
    public static String qualify(String catalog, String schema, String table) {
        StringBuilder qualifiedName = new StringBuilder();
        if (catalog != null) {
            qualifiedName.append(catalog).append('.');
        }
        if (schema != null) {
            qualifiedName.append(schema).append('.');
        }
        return qualifiedName.append(table).toString();
    }

    @Override
    public Collection<PhysicalColumn> getPhysicalColumns() {
        return this.getColumns().stream().filter(PhysicalColumn.class::isInstance).map(column -> (PhysicalColumn)column).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public void setCheckConstraints(List<String> checkConstraints) {
        this.checkConstraints = checkConstraints;
    }

    @Override
    public List<String> getCheckConstraints() {
        return this.checkConstraints;
    }

    @Override
    public Collection<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public boolean isPrimaryKeyIdentity() {
        return this.primaryKeyIdentity;
    }

    @Override
    public Collection<InitCommand> getInitCommands() {
        return this.initCommands;
    }

    public void addInitCommand(InitCommand command) {
        this.initCommands.add(command);
    }

    public void setPrimaryKeyIdentity(boolean primaryKeyIdentity) {
        this.primaryKeyIdentity = primaryKeyIdentity;
    }

    public void addIndex(Index index) {
        this.indexes.add(index);
    }

    private String render(Identifier identifier) {
        return identifier == null ? null : identifier.render();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalTable that = (PhysicalTable)o;
        return Objects.equals(this.qualifiedTableName, that.qualifiedTableName);
    }

    public int hashCode() {
        return Objects.hash(this.qualifiedTableName);
    }

    @Override
    public String toLoggableFragment() {
        return this.getQualifiedTableName().toLoggableFragment();
    }
}

