/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.MappedAuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedForeignKey;
import org.hibernate.boot.model.relational.MappedNamespace;
import org.hibernate.boot.model.relational.MappedPrimaryKey;
import org.hibernate.boot.model.relational.MappedSequence;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.model.relational.MappedUniqueKey;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.metamodel.model.creation.spi.DatabaseObjectResolver;
import org.hibernate.metamodel.model.relational.internal.ColumnMappingImpl;
import org.hibernate.metamodel.model.relational.internal.ColumnMappingsImpl;
import org.hibernate.metamodel.model.relational.internal.DatabaseModelImpl;
import org.hibernate.metamodel.model.relational.internal.InflightTable;
import org.hibernate.metamodel.model.relational.internal.NamespaceImpl;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.DatabaseModel;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.metamodel.model.relational.spi.Namespace;
import org.hibernate.metamodel.model.relational.spi.PhysicalNamingStrategy;
import org.hibernate.metamodel.model.relational.spi.PrimaryKey;
import org.hibernate.metamodel.model.relational.spi.Sequence;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.metamodel.model.relational.spi.UniqueKey;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class RuntimeDatabaseModelProducer {
    private static final Logger log = Logger.getLogger(RuntimeDatabaseModelProducer.class);
    private final PhysicalNamingStrategy namingStrategy;
    private final JdbcEnvironment jdbcEnvironment;
    private final IdentifierGeneratorFactory identifierGeneratorFactory;
    private final TypeConfiguration typeConfiguration;

    public RuntimeDatabaseModelProducer(BootstrapContext bootstrapContext) {
        this(bootstrapContext.getServiceRegistry(), bootstrapContext.getMetadataBuildingOptions().getPhysicalNamingStrategy(), bootstrapContext.getTypeConfiguration());
    }

    public RuntimeDatabaseModelProducer(StandardServiceRegistry serviceRegistry, PhysicalNamingStrategy namingStrategy, TypeConfiguration typeConfiguration) {
        this.namingStrategy = namingStrategy;
        this.jdbcEnvironment = serviceRegistry.getService(JdbcServices.class).getJdbcEnvironment();
        this.identifierGeneratorFactory = serviceRegistry.getService(MutableIdentifierGeneratorFactory.class);
        this.typeConfiguration = typeConfiguration;
    }

    public DatabaseModel produceDatabaseModel(Database database, DatabaseObjectResolver dbObjectResolver, Callback callback) {
        return new Process(callback, dbObjectResolver, database).execute();
    }

    public static interface Callback {
        default public void namespaceBuilt(MappedNamespace mappedNamespace, Namespace namespace) {
        }

        default public void tableBuilt(MappedTable mappedTable, Table table) {
        }

        default public void columnBuilt(MappedColumn mappedColumn, Column column) {
        }

        default public void primaryKeyBuilt(MappedPrimaryKey bootPk, PrimaryKey runtimePk) {
        }

        default public void foreignKeyBuilt(MappedForeignKey mappedFk, ForeignKey runtimeFk) {
        }

        default public void uniqueKeyBuilt(MappedUniqueKey mappedUk, UniqueKey runtimeUk) {
        }

        default public void sequenceBuilt(Sequence sequence) {
        }
    }

    class Process {
        private final Callback callback;
        private final DatabaseObjectResolver dbObjectResolver;
        private final Database bootDatabaseModel;

        public Process(Callback callback, DatabaseObjectResolver dbObjectResolver, Database bootDatabaseModel) {
            this.callback = callback;
            this.dbObjectResolver = dbObjectResolver;
            this.bootDatabaseModel = bootDatabaseModel;
        }

        private DatabaseModel execute() {
            DatabaseModelImpl runtimeDatabaseModel = new DatabaseModelImpl(this.bootDatabaseModel.getJdbcEnvironment());
            for (MappedNamespace bootModelNamespace : this.bootDatabaseModel.getNamespaces()) {
                NamespaceImpl runtimeModelNamespace = this.generateNamespace(runtimeDatabaseModel, bootModelNamespace);
                if (bootModelNamespace == this.bootDatabaseModel.getDefaultNamespace()) {
                    runtimeDatabaseModel.setDefaultNamespace(runtimeModelNamespace);
                }
                this.processTables(bootModelNamespace, runtimeModelNamespace);
                this.processSequences(bootModelNamespace, runtimeModelNamespace);
            }
            this.processForeignKeys(this.bootDatabaseModel, runtimeDatabaseModel);
            for (MappedAuxiliaryDatabaseObject mappedAuxiliaryDatabaseObject : this.bootDatabaseModel.getAuxiliaryDatabaseObjects()) {
                runtimeDatabaseModel.addAuxiliaryDatabaseObject(mappedAuxiliaryDatabaseObject.generateRuntimeAuxiliaryDatabaseObject(this.bootDatabaseModel.getJdbcEnvironment().getDialect()));
            }
            for (InitCommand command : this.bootDatabaseModel.getInitCommands()) {
                runtimeDatabaseModel.addInitCommand(command);
            }
            return runtimeDatabaseModel;
        }

        private NamespaceImpl generateNamespace(DatabaseModelImpl databaseModel, MappedNamespace bootModelNamespace) {
            NamespaceImpl runtimeModelNamespace = this.generateRuntimeNamespace(bootModelNamespace);
            databaseModel.addNamespace(runtimeModelNamespace);
            this.callback.namespaceBuilt(bootModelNamespace, runtimeModelNamespace);
            return runtimeModelNamespace;
        }

        private void generateDefaultNamespace(DatabaseModelImpl databaseModel) {
            MappedNamespace bootModelDefaultNamespace = this.bootDatabaseModel.getDefaultNamespace();
            NamespaceImpl runtimeModelDefaultNamespace = this.generateRuntimeNamespace(bootModelDefaultNamespace);
            this.callback.namespaceBuilt(bootModelDefaultNamespace, runtimeModelDefaultNamespace);
        }

        private NamespaceImpl generateRuntimeNamespace(MappedNamespace bootModelNamespace) {
            return new NamespaceImpl(RuntimeDatabaseModelProducer.this.namingStrategy.toPhysicalCatalogName(bootModelNamespace.getName().getCatalog(), RuntimeDatabaseModelProducer.this.jdbcEnvironment), RuntimeDatabaseModelProducer.this.namingStrategy.toPhysicalSchemaName(bootModelNamespace.getName().getSchema(), RuntimeDatabaseModelProducer.this.jdbcEnvironment));
        }

        private void processTables(MappedNamespace bootModelNamespace, NamespaceImpl runtimeModelNamespace) {
            for (MappedTable mappedTable : bootModelNamespace.getTables()) {
                if (!mappedTable.isExportable()) continue;
                InflightTable runtimeTable = mappedTable.generateRuntimeTable(RuntimeDatabaseModelProducer.this.namingStrategy, RuntimeDatabaseModelProducer.this.jdbcEnvironment, RuntimeDatabaseModelProducer.this.identifierGeneratorFactory, this.callback, RuntimeDatabaseModelProducer.this.typeConfiguration);
                runtimeModelNamespace.addTable(runtimeTable);
            }
        }

        private void processSequences(MappedNamespace bootModelNamespace, NamespaceImpl runtimeModelNamespace) {
            for (MappedSequence mappedSequence : bootModelNamespace.getSequences()) {
                Sequence runtimeSequence = mappedSequence.generateRuntimeSequence(RuntimeDatabaseModelProducer.this.namingStrategy, RuntimeDatabaseModelProducer.this.jdbcEnvironment);
                runtimeModelNamespace.addSequence(runtimeSequence);
                this.callback.sequenceBuilt(runtimeSequence);
            }
        }

        private void processForeignKeys(Database bootDatabaseModel, DatabaseModelImpl runtimeDatabaseModel) {
            for (MappedNamespace bootModelNamespace : bootDatabaseModel.getNamespaces()) {
                for (MappedTable bootTable : bootModelNamespace.getTables()) {
                    log.tracef("Processing FKs for table : %s", (Object)bootTable);
                    for (MappedForeignKey bootFk : bootTable.getForeignKeys()) {
                        log.tracef("Processing mapped FK to runtime FK : %s", (Object)bootFk);
                        bootFk.alignColumns();
                        Table runtimeReferringTable = this.dbObjectResolver.resolveTable(bootTable);
                        Table runtimeTargetTable = this.dbObjectResolver.resolveTable(bootFk.getReferencedTable());
                        ArrayList<ForeignKey.ColumnMappings.ColumnMapping> columnMappingList = new ArrayList<ForeignKey.ColumnMappings.ColumnMapping>();
                        List<MappedColumn> bootReferringColumns = bootFk.getColumns();
                        List<MappedColumn> bootTargetColumns = bootFk.getTargetColumns();
                        this.assertSameNumberOfFkColumns(bootReferringColumns, bootTargetColumns);
                        int end = bootReferringColumns.size();
                        for (int i = 0; i < end; ++i) {
                            Column runtimeReferringColumn = this.resolveRuntimeColumn(bootReferringColumns.get(i));
                            if (runtimeReferringColumn == null) {
                                runtimeReferringColumn = runtimeReferringTable.getPrimaryKey().getColumns().get(i);
                            }
                            assert (runtimeReferringColumn != null);
                            Column runtimeTargetColumn = this.resolveRuntimeColumn(bootTargetColumns.get(i));
                            if (runtimeTargetColumn == null) {
                                PrimaryKey targetPk = runtimeTargetTable.getPrimaryKey();
                                assert (targetPk != null);
                                assert (!targetPk.getColumns().isEmpty());
                                runtimeTargetColumn = targetPk.getColumns().get(i);
                            }
                            assert (runtimeTargetColumn != null);
                            columnMappingList.add(new ColumnMappingImpl(runtimeReferringColumn, runtimeTargetColumn));
                        }
                        ForeignKey runtimeFk = ((InflightTable)runtimeReferringTable).createForeignKey(bootFk.getName(), bootFk.isCreationEnabled() && bootFk.isPhysicalConstraint(), bootFk.getKeyDefinition(), bootFk.isCascadeDeleteEnabled(), bootFk.isReferenceToPrimaryKey(), runtimeTargetTable, new ColumnMappingsImpl(runtimeReferringTable, runtimeTargetTable, columnMappingList));
                        this.callback.foreignKeyBuilt(bootFk, runtimeFk);
                    }
                }
            }
        }

        private Column resolveRuntimeColumn(MappedColumn bootColumn) {
            return this.dbObjectResolver.resolveColumn(bootColumn);
        }

        private void assertSameNumberOfFkColumns(List referringColumns, List targetColumns) {
            assert (referringColumns != null);
            assert (targetColumns != null);
            if (referringColumns.size() != targetColumns.size()) {
                throw new MappingException("FK column counts did not match");
            }
        }
    }
}

