/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.spi;

import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.metamodel.model.relational.spi.Exportable;
import org.hibernate.metamodel.model.relational.spi.PhysicalNamingStrategy;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.QualifiedSequenceName;

public class Sequence
implements Exportable {
    private int initialValue = 1;
    private int incrementSize = 1;
    private final Identifier name;
    private final QualifiedSequenceName qualifiedName;

    public Sequence(Identifier logicalCatalogName, Identifier logicalSchemaName, Identifier logicalSequenceName, int initialValue, int incrementSize, PhysicalNamingStrategy namingStrategy, JdbcEnvironment jdbcEnvironment) {
        this.name = namingStrategy.toPhysicalTableName(logicalSequenceName, jdbcEnvironment);
        this.qualifiedName = new QualifiedSequenceName(namingStrategy.toPhysicalCatalogName(logicalCatalogName, jdbcEnvironment), namingStrategy.toPhysicalCatalogName(logicalSchemaName, jdbcEnvironment), this.name);
        this.initialValue = initialValue;
        this.incrementSize = incrementSize;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public Identifier getName() {
        return this.name;
    }

    public QualifiedSequenceName getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getExportIdentifier() {
        return this.getQualifiedName().render();
    }

    public String toString() {
        return "Sequence(" + this.getName() + ")";
    }
}

