/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.spi;

import java.io.Serializable;
import org.hibernate.HibernateException;

public class Size
implements Serializable {
    private final Integer precision;
    private final Integer scale;
    private final Long length;
    private final LobMultiplier lobMultiplier;

    private Size(Integer precision, Integer scale, Long length, LobMultiplier lobMultiplier) {
        this.precision = precision;
        this.scale = scale;
        this.length = length;
        this.lobMultiplier = lobMultiplier;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Long getLength() {
        return this.length;
    }

    public LobMultiplier getLobMultiplier() {
        return this.lobMultiplier;
    }

    public static class Builder {
        public static final long DEFAULT_LENGTH = 255L;
        public static final int DEFAULT_PRECISION = 19;
        public static final int DEFAULT_SCALE = 2;
        private Integer precision;
        private Integer scale;
        private Long length;
        private LobMultiplier lobMultiplier = LobMultiplier.NONE;

        public static Size length(long length) {
            return new Size(null, null, length, null);
        }

        public static Size length(long length, LobMultiplier lobMultiplier) {
            return new Size(null, null, length, lobMultiplier);
        }

        public static Size precision(int precision) {
            return new Size(precision, null, null, null);
        }

        public static Size precision(int precision, int scale) {
            return new Size(precision, scale, null, null);
        }

        public Long getLength() {
            return this.length;
        }

        public Builder setLength(Long length) {
            this.length = length;
            return this;
        }

        public LobMultiplier getLobMultiplier() {
            return this.lobMultiplier;
        }

        public Builder setLobMultiplier(LobMultiplier lobMultiplier) {
            this.lobMultiplier = lobMultiplier;
            return this;
        }

        public Integer getPrecision() {
            return this.precision;
        }

        public Builder setPrecision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public Integer getScale() {
            return this.scale;
        }

        public Builder setScale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public Size build() {
            if (this.length != null && (this.precision != null || this.scale != null)) {
                throw new HibernateException("Illegal attempt to specify both length and precision/scale for column size");
            }
            if (this.precision != null && this.lobMultiplier != LobMultiplier.NONE) {
                throw new HibernateException("Illegal attempt to specify LobMultiplier with precision/scale");
            }
            return new Size(this.precision, this.scale, this.length, this.lobMultiplier);
        }
    }

    public static enum LobMultiplier {
        NONE(1L),
        K(LobMultiplier.NONE.factor * 1024L),
        M(LobMultiplier.K.factor * 1024L),
        G(LobMultiplier.M.factor * 1024L);

        private long factor;

        private LobMultiplier(long factor) {
            this.factor = factor;
        }

        public long getFactor() {
            return this.factor;
        }
    }
}

