/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.relational.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.relational.spi.Exportable;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.naming.Identifier;

public class UniqueKey
implements Exportable {
    private Table table;
    private Identifier name;
    private List<PhysicalColumn> columns = new ArrayList<PhysicalColumn>();
    private Map<PhysicalColumn, String> columnOrderMap = new HashMap<PhysicalColumn, String>();

    public UniqueKey(Identifier name, Table table) {
        this.name = name;
        this.table = table;
    }

    public Identifier getName() {
        return this.name;
    }

    public Table getTable() {
        return this.table;
    }

    public Collection<PhysicalColumn> getColumns() {
        return this.columns;
    }

    public Map<PhysicalColumn, String> getColumnOrderMap() {
        return this.columnOrderMap;
    }

    public void addColumn(PhysicalColumn column, String order) {
        this.columns.add(column);
        if (order != null && !"".equals(order)) {
            this.columnOrderMap.put(column, order);
        }
    }

    @Override
    public String getExportIdentifier() {
        return StringHelper.qualify(((ExportableTable)this.getTable()).getExportIdentifier(), "UK-" + this.getName().getText());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniqueKey uniqueKey = (UniqueKey)o;
        return Objects.equals(this.table, uniqueKey.table) && Objects.equals(this.name, uniqueKey.name);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.name);
    }
}

