/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.hibernate.EntityNameResolver;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.metamodel.NotNavigableException;
import org.hibernate.metamodel.RuntimeModel;
import org.hibernate.metamodel.model.creation.spi.InFlightRuntimeModel;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.MappedSuperclassTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public abstract class AbstractRuntimeModel
implements RuntimeModel {
    private final Set<EntityHierarchy> entityHierarchySet;
    private final Map<String, EntityTypeDescriptor<?>> entityDescriptorMap;
    private final Map<String, MappedSuperclassTypeDescriptor<?>> mappedSuperclassDescriptorMap;
    private final Map<String, EmbeddedTypeDescriptor<?>> embeddedDescriptorMap;
    private final Map<String, PersistentCollectionDescriptor<?, ?, ?>> collectionDescriptorMap;
    private final Map<String, String> nameImportMap;
    private final Set<EntityNameResolver> entityNameResolvers;
    private final Map<String, RootGraphImplementor<?>> entityGraphMap;

    public AbstractRuntimeModel() {
        this.entityDescriptorMap = new ConcurrentHashMap();
        this.entityHierarchySet = ConcurrentHashMap.newKeySet();
        this.mappedSuperclassDescriptorMap = new ConcurrentHashMap();
        this.embeddedDescriptorMap = new ConcurrentHashMap();
        this.collectionDescriptorMap = new ConcurrentHashMap();
        this.nameImportMap = new ConcurrentHashMap<String, String>();
        this.entityNameResolvers = ConcurrentHashMap.newKeySet();
        this.entityGraphMap = new ConcurrentHashMap();
    }

    public AbstractRuntimeModel(InFlightRuntimeModel inFlightModel) {
        this(inFlightModel.getEntityHierarchySet(), inFlightModel.getEntityDescriptorMap(), inFlightModel.getMappedSuperclassDescriptorMap(), inFlightModel.getEmbeddedDescriptorMap(), inFlightModel.getCollectionDescriptorMap(), inFlightModel.getEntityNameResolvers(), inFlightModel.getNameImportMap(), inFlightModel.getRootGraphMap());
    }

    private AbstractRuntimeModel(Set<EntityHierarchy> entityHierarchySet, Map<String, EntityTypeDescriptor<?>> entityDescriptorMap, Map<String, MappedSuperclassTypeDescriptor<?>> mappedSuperclassDescriptorMap, Map<String, EmbeddedTypeDescriptor<?>> embeddedDescriptorMap, Map<String, PersistentCollectionDescriptor<?, ?, ?>> collectionDescriptorMap, Set<EntityNameResolver> entityNameResolvers, Map<String, String> nameImportMap, Map<String, RootGraphImplementor<?>> entityGraphMap) {
        this.entityHierarchySet = Collections.unmodifiableSet(entityHierarchySet);
        this.entityDescriptorMap = Collections.unmodifiableMap(entityDescriptorMap);
        this.mappedSuperclassDescriptorMap = Collections.unmodifiableMap(mappedSuperclassDescriptorMap);
        this.embeddedDescriptorMap = Collections.unmodifiableMap(embeddedDescriptorMap);
        this.collectionDescriptorMap = Collections.unmodifiableMap(collectionDescriptorMap);
        this.entityNameResolvers = Collections.unmodifiableSet(entityNameResolvers);
        this.entityGraphMap = new ConcurrentHashMap(entityGraphMap);
        this.nameImportMap = new ConcurrentHashMap<String, String>(nameImportMap);
    }

    protected Set<EntityHierarchy> getEntityHierarchySet() {
        return this.entityHierarchySet;
    }

    @Override
    public void visitEntityHierarchies(Consumer<EntityHierarchy> action) {
        this.entityHierarchySet.forEach(action);
    }

    protected Map<String, EntityTypeDescriptor<?>> getEntityDescriptorMap() {
        return this.entityDescriptorMap;
    }

    @Override
    public <T> EntityTypeDescriptor<T> getEntityDescriptor(Class<T> javaType) {
        return this.getEntityDescriptor(javaType.getName());
    }

    @Override
    public <T> EntityTypeDescriptor<T> getEntityDescriptor(NavigableRole name) {
        return this.getEntityDescriptor(name.getFullPath());
    }

    @Override
    public <T> EntityTypeDescriptor<T> getEntityDescriptor(String entityName) throws NotNavigableException {
        EntityTypeDescriptor<?> descriptor = this.entityDescriptorMap.get(entityName);
        if (descriptor == null) {
            throw new NotNavigableException(entityName);
        }
        return descriptor;
    }

    @Override
    public <T> EntityTypeDescriptor<T> findEntityDescriptor(Class<T> javaType) {
        return this.entityDescriptorMap.get(javaType.getName());
    }

    @Override
    public <T> EntityTypeDescriptor<T> findEntityDescriptor(String entityName) {
        String importedName = this.getImportedName(entityName);
        if (importedName != null) {
            entityName = importedName;
        }
        return this.entityDescriptorMap.get(entityName);
    }

    @Override
    public void visitEntityDescriptors(Consumer<EntityTypeDescriptor<?>> action) {
        this.entityDescriptorMap.values().forEach(action);
    }

    protected Map<String, MappedSuperclassTypeDescriptor<?>> getMappedSuperclassDescriptorMap() {
        return this.mappedSuperclassDescriptorMap;
    }

    @Override
    public <T> MappedSuperclassTypeDescriptor<T> getMappedSuperclassDescriptor(NavigableRole role) throws NotNavigableException {
        return this.getMappedSuperclassDescriptor(role.getFullPath());
    }

    @Override
    public <T> MappedSuperclassTypeDescriptor<T> getMappedSuperclassDescriptor(Class<T> javaType) throws NotNavigableException {
        return this.getMappedSuperclassDescriptor(javaType.getName());
    }

    @Override
    public <T> MappedSuperclassTypeDescriptor<T> getMappedSuperclassDescriptor(String name) throws NotNavigableException {
        MappedSuperclassTypeDescriptor<?> descriptor = this.mappedSuperclassDescriptorMap.get(name);
        if (descriptor == null) {
            throw new NotNavigableException(name);
        }
        return descriptor;
    }

    @Override
    public <T> MappedSuperclassTypeDescriptor<T> findMappedSuperclassDescriptor(Class<T> javaType) {
        return this.mappedSuperclassDescriptorMap.get(javaType.getName());
    }

    @Override
    public <T> MappedSuperclassTypeDescriptor<T> findMappedSuperclassDescriptor(String name) {
        name = this.getImportedName(name);
        return this.mappedSuperclassDescriptorMap.get(name);
    }

    @Override
    public void visitMappedSuperclassDescriptors(Consumer<MappedSuperclassTypeDescriptor<?>> action) {
        this.mappedSuperclassDescriptorMap.values().forEach(action);
    }

    protected Map<String, EmbeddedTypeDescriptor<?>> getEmbeddedDescriptorMap() {
        return this.embeddedDescriptorMap;
    }

    @Override
    public <T> EmbeddedTypeDescriptor<T> findEmbeddedDescriptor(Class<T> javaType) {
        return this.findEmbeddedDescriptor(javaType.getName());
    }

    @Override
    public <T> EmbeddedTypeDescriptor<T> findEmbeddedDescriptor(NavigableRole name) {
        return this.findEmbeddedDescriptor(name.getFullPath());
    }

    @Override
    public <T> EmbeddedTypeDescriptor<T> findEmbeddedDescriptor(String name) {
        return this.embeddedDescriptorMap.get(name);
    }

    @Override
    public void visitEmbeddedDescriptors(Consumer<EmbeddedTypeDescriptor<?>> action) {
        this.embeddedDescriptorMap.values().forEach(action);
    }

    protected Map<String, PersistentCollectionDescriptor<?, ?, ?>> getCollectionDescriptorMap() {
        return this.collectionDescriptorMap;
    }

    @Override
    public <O, C, E> PersistentCollectionDescriptor<O, C, E> getCollectionDescriptor(NavigableRole name) throws NotNavigableException {
        return this.getCollectionDescriptor(name.getFullPath());
    }

    @Override
    public <O, C, E> PersistentCollectionDescriptor<O, C, E> getCollectionDescriptor(String name) throws NotNavigableException {
        PersistentCollectionDescriptor<O, C, E> descriptor = this.findCollectionDescriptor(name);
        if (descriptor == null) {
            throw new NotNavigableException(name);
        }
        return descriptor;
    }

    @Override
    public <O, C, E> PersistentCollectionDescriptor<O, C, E> findCollectionDescriptor(NavigableRole name) {
        return this.findCollectionDescriptor(name.getFullPath());
    }

    @Override
    public <O, C, E> PersistentCollectionDescriptor<O, C, E> findCollectionDescriptor(String name) {
        return this.collectionDescriptorMap.get(name);
    }

    @Override
    public void visitCollectionDescriptors(Consumer<PersistentCollectionDescriptor<?, ?, ?>> action) {
        this.collectionDescriptorMap.values().forEach(action);
    }

    protected Map<String, RootGraphImplementor<?>> getRootGraphMap() {
        return this.entityGraphMap;
    }

    public <T> RootGraphImplementor<? super T> findRootGraph(String name) {
        return this.entityGraphMap.get(name);
    }

    @Override
    public <T> List<RootGraph<? super T>> findRootGraphsForType(Class<T> baseType) {
        return this.findRootGraphsForType(baseType.getName());
    }

    @Override
    public <T> List<RootGraph<? super T>> findRootGraphsForType(String baseTypeName) {
        EntityTypeDescriptor<T> entityDescriptor = this.findEntityDescriptor(baseTypeName);
        if (entityDescriptor == null) {
            throw new IllegalArgumentException("Not an entity : " + baseTypeName);
        }
        ArrayList<RootGraph<T>> results = new ArrayList<RootGraph<T>>();
        for (RootGraphImplementor<?> rootGraph : this.entityGraphMap.values()) {
            if (!rootGraph.appliesTo(entityDescriptor)) continue;
            results.add(rootGraph);
        }
        return results;
    }

    @Override
    public void visitRootGraphs(Consumer<RootGraph<?>> action) {
        this.entityGraphMap.values().forEach(action);
    }

    @Override
    public Set<EntityNameResolver> getEntityNameResolvers() {
        return this.entityNameResolvers;
    }

    @Override
    public void visitEntityNameResolvers(Consumer<EntityNameResolver> action) {
        this.entityNameResolvers.forEach(action);
    }

    protected Map<String, String> getNameImportMap() {
        return this.nameImportMap;
    }

    @Override
    public String getImportedName(String name) {
        return this.nameImportMap.getOrDefault(name, name);
    }
}

