/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.naming;

import java.util.Objects;
import org.hibernate.naming.Identifier;

public class NamespaceName
implements Comparable<NamespaceName> {
    private final Identifier catalog;
    private final Identifier schema;

    public NamespaceName(Identifier catalog, Identifier schema) {
        this.catalog = catalog;
        this.schema = schema;
    }

    public Identifier getCatalog() {
        return this.catalog;
    }

    public Identifier getSchema() {
        return this.schema;
    }

    public String toString() {
        return "Name{catalog=" + this.catalog + ", schema=" + this.schema + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceName that = (NamespaceName)o;
        return Objects.equals(this.catalog, that.catalog) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        int result = this.catalog != null ? this.catalog.hashCode() : 0;
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(NamespaceName that) {
        int catalogCheck = NamespaceName.compare(this.catalog, that.catalog);
        if (catalogCheck != 0) {
            return catalogCheck;
        }
        return NamespaceName.compare(this.schema, that.schema);
    }

    public static <T extends Comparable<T>> int compare(T first, T second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return 1;
        }
        if (second == null) {
            return -1;
        }
        return first.compareTo(second);
    }
}

