/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.pretty;

import java.io.Serializable;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public final class MessageHelper {
    private MessageHelper() {
    }

    public static String infoString(String entityName, Object id) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (entityName == null) {
            s.append("<null entity name>");
        } else {
            s.append(entityName);
        }
        s.append('#');
        if (id == null) {
            s.append("<null>");
        } else {
            s.append(id);
        }
        s.append(']');
        return s.toString();
    }

    @Deprecated
    public static String infoString(String entityName, Serializable id) {
        return MessageHelper.infoString(entityName, (Object)id);
    }

    public static String infoString(EntityTypeDescriptor entityDescriptor, Object id, SessionFactoryImplementor factory) {
        JavaTypeDescriptor idJavaTypeDescriptor;
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (entityDescriptor == null) {
            s.append("<null EntityPersister>");
            idJavaTypeDescriptor = null;
        } else {
            s.append(entityDescriptor.getEntityName());
            idJavaTypeDescriptor = entityDescriptor.getIdentifierDescriptor().getJavaTypeDescriptor();
        }
        s.append('#');
        if (id == null) {
            s.append("<null>");
        } else if (idJavaTypeDescriptor == null) {
            s.append(id);
        } else if (factory != null) {
            s.append(idJavaTypeDescriptor.extractLoggableRepresentation(id));
        } else {
            s.append("<not loggable>");
        }
        s.append(']');
        return s.toString();
    }

    public static String infoString(EntityTypeDescriptor entityDescriptor, Object id, JavaTypeDescriptor identifierJavaTypeDescriptor, SessionFactoryImplementor factory) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (entityDescriptor == null) {
            s.append("<null EntityPersister>");
        } else {
            s.append(entityDescriptor.getEntityName());
        }
        s.append('#');
        if (id == null) {
            s.append("<null>");
        } else {
            s.append(identifierJavaTypeDescriptor.extractLoggableRepresentation(id));
        }
        s.append(']');
        return s.toString();
    }

    public static String infoString(EntityTypeDescriptor entityDescriptor, Serializable[] ids, SessionFactoryImplementor factory) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (entityDescriptor == null) {
            s.append("<null EntityPersister>");
        } else {
            s.append(entityDescriptor.getEntityName());
            s.append("#<");
            for (int i = 0; i < ids.length; ++i) {
                s.append(entityDescriptor.getIdentifierDescriptor().getJavaTypeDescriptor().extractLoggableRepresentation(ids[i]));
                if (i >= ids.length - 1) continue;
                s.append(", ");
            }
            s.append('>');
        }
        s.append(']');
        return s.toString();
    }

    public static String infoString(EntityTypeDescriptor descriptor) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (descriptor == null) {
            s.append("<null EntityPersister>");
        } else {
            s.append(descriptor.getEntityName());
        }
        s.append(']');
        return s.toString();
    }

    public static String infoString(String entityName, String propertyName, Object key) {
        StringBuilder s = new StringBuilder().append('[').append(entityName).append('.').append(propertyName).append('#');
        if (key == null) {
            s.append("<null>");
        } else {
            s.append(key);
        }
        s.append(']');
        return s.toString();
    }

    public static String collectionInfoString(PersistentCollectionDescriptor collectionDescriptor, PersistentCollection collection, Object collectionKey, SharedSessionContractImplementor session) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (collectionDescriptor == null) {
            s.append("<unreferenced>");
        } else {
            Object ownerKey;
            s.append(collectionDescriptor.getNavigableRole().getFullPath());
            s.append('#');
            org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor ownerIdentifierJavaTypeDescriptor = collectionDescriptor.getCollectionKeyDescriptor().getJavaTypeDescriptor();
            if (collectionKey.getClass().isAssignableFrom(ownerIdentifierJavaTypeDescriptor.getJavaType())) {
                ownerKey = collectionKey;
            } else {
                Object collectionOwner = collection == null ? null : collection.getOwner();
                EntityEntry entry = collectionOwner == null ? null : session.getPersistenceContext().getEntry(collectionOwner);
                ownerKey = entry == null ? null : entry.getId();
            }
            s.append(ownerIdentifierJavaTypeDescriptor.extractLoggableRepresentation(ownerKey));
        }
        s.append(']');
        return s.toString();
    }

    public static String collectionInfoString(PersistentCollectionDescriptor collectionDescriptor, PersistentCollection collection, Serializable collectionKey, SharedSessionContractImplementor session) {
        return MessageHelper.collectionInfoString(collectionDescriptor, collection, (Object)collectionKey, session);
    }

    public static String collectionInfoString(PersistentCollectionDescriptor collectionDescriptor, Object[] ids, SessionFactoryImplementor factory) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (collectionDescriptor == null) {
            s.append("<unreferenced>");
        } else {
            s.append(collectionDescriptor.getNavigableRole().getFullPath());
            s.append("#<");
            for (int i = 0; i < ids.length; ++i) {
                MessageHelper.addIdToCollectionInfoString(collectionDescriptor, ids[i], factory, s);
                if (i >= ids.length - 1) continue;
                s.append(", ");
            }
            s.append('>');
        }
        s.append(']');
        return s.toString();
    }

    @Deprecated
    public static String collectionInfoString(PersistentCollectionDescriptor collectionDescriptor, Serializable[] ids, SessionFactoryImplementor factory) {
        return MessageHelper.collectionInfoString(collectionDescriptor, (Object[])ids, factory);
    }

    public static String collectionInfoString(PersistentCollectionDescriptor collectionDescriptor, Object id, SessionFactoryImplementor factory) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (collectionDescriptor == null) {
            s.append("<unreferenced>");
        } else {
            s.append(collectionDescriptor.getNavigableRole().getFullPath());
            s.append('#');
            if (id == null) {
                s.append("<null>");
            } else {
                MessageHelper.addIdToCollectionInfoString(collectionDescriptor, id, factory, s);
            }
        }
        s.append(']');
        return s.toString();
    }

    @Deprecated
    public static String collectionInfoString(PersistentCollectionDescriptor collectionDescriptor, Serializable id, SessionFactoryImplementor factory) {
        return MessageHelper.collectionInfoString(collectionDescriptor, (Object)id, factory);
    }

    private static void addIdToCollectionInfoString(PersistentCollectionDescriptor collectionDescriptor, Object id, SessionFactoryImplementor factory, StringBuilder s) {
        org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor ownerIdentifierJavaTypeDescriptor = collectionDescriptor.getCollectionKeyDescriptor().getJavaTypeDescriptor();
        if (id.getClass().isAssignableFrom(ownerIdentifierJavaTypeDescriptor.getJavaType())) {
            s.append(ownerIdentifierJavaTypeDescriptor.extractLoggableRepresentation(id));
        } else {
            s.append(id.toString());
        }
    }

    public static String collectionInfoString(String role, Object id) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (role == null) {
            s.append("<unreferenced>");
        } else {
            s.append(role);
            s.append('#');
            if (id == null) {
                s.append("<null>");
            } else {
                s.append(id);
            }
        }
        s.append(']');
        return s.toString();
    }

    public static String collectionInfoString(String role, Serializable id) {
        return MessageHelper.collectionInfoString(role, (Object)id);
    }
}

