/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import javax.persistence.ParameterMode;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.procedure.spi.FunctionReturnImplementor;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.named.spi.ParameterMemento;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.exec.internal.JdbcCallFunctionReturnImpl;
import org.hibernate.sql.exec.internal.JdbcCallParameterExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcCallRefCursorExtractorImpl;
import org.hibernate.sql.exec.spi.JdbcCallFunctionReturn;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class FunctionReturnImpl
implements FunctionReturnImplementor {
    private final ProcedureCallImplementor procedureCall;
    private int jdbcTypeCode;
    private BasicValuedExpressableType ormType;

    public FunctionReturnImpl(ProcedureCallImplementor procedureCall, int jdbcTypeCode) {
        this.procedureCall = procedureCall;
        this.jdbcTypeCode = jdbcTypeCode;
    }

    public FunctionReturnImpl(ProcedureCallImplementor procedureCall, BasicValuedExpressableType ormType) {
        this.procedureCall = procedureCall;
        this.jdbcTypeCode = ormType.getSqlTypeDescriptor().getJdbcTypeCode();
        this.ormType = ormType;
    }

    public JdbcCallFunctionReturn toJdbcFunctionReturn(SharedSessionContractImplementor persistenceContext) {
        JdbcCallParameterExtractorImpl parameterExtractor;
        BasicType ormType;
        JdbcCallRefCursorExtractorImpl refCursorExtractor;
        if (this.getJdbcTypeCode() == 2012) {
            refCursorExtractor = new JdbcCallRefCursorExtractorImpl(null, 0);
            ormType = null;
            parameterExtractor = null;
        } else {
            TypeConfiguration typeConfiguration = persistenceContext.getFactory().getMetamodel().getTypeConfiguration();
            SqlTypeDescriptor sqlTypeDescriptor = typeConfiguration.getSqlTypeDescriptorRegistry().getDescriptor(this.getJdbcTypeCode());
            BasicJavaDescriptor javaTypeMapping = sqlTypeDescriptor.getJdbcRecommendedJavaTypeMapping(typeConfiguration);
            ormType = typeConfiguration.getBasicTypeRegistry().getBasicType(javaTypeMapping.getJavaType());
            parameterExtractor = new JdbcCallParameterExtractorImpl(this.procedureCall.getProcedureName(), null, 0, ormType);
            refCursorExtractor = null;
        }
        return new JdbcCallFunctionReturnImpl(this.getJdbcTypeCode(), ormType, parameterExtractor, refCursorExtractor);
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcTypeCode;
    }

    @Override
    public AllowableParameterType getHibernateType() {
        return this.ormType;
    }

    public String getName() {
        return null;
    }

    public Integer getPosition() {
        return 0;
    }

    @Override
    public ParameterMode getMode() {
        return ParameterMode.OUT;
    }

    public Class getParameterType() {
        return this.ormType == null ? null : this.ormType.getJavaType();
    }

    @Override
    public void disallowMultiValuedBinding() {
    }

    @Override
    public boolean allowsMultiValuedBinding() {
        return false;
    }

    @Override
    public ParameterMemento toMemento() {
        return new ParameterMemento(){

            @Override
            public QueryParameter toQueryParameter(SharedSessionContractImplementor session) {
                if (FunctionReturnImpl.this.ormType != null) {
                    return new FunctionReturnImpl(FunctionReturnImpl.this.procedureCall, FunctionReturnImpl.this.ormType);
                }
                return new FunctionReturnImpl(FunctionReturnImpl.this.procedureCall, FunctionReturnImpl.this.jdbcTypeCode);
            }
        };
    }
}

