/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import javax.persistence.ParameterMode;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.internal.FunctionReturnImpl;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureParamBindings;
import org.hibernate.procedure.spi.ProcedureParameterMetadata;
import org.hibernate.sql.exec.spi.JdbcCall;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;

public class PostgresCallableStatementSupport
implements CallableStatementSupport {
    public static final PostgresCallableStatementSupport INSTANCE = new PostgresCallableStatementSupport();

    @Override
    public JdbcCall interpretCall(String procedureName, FunctionReturnImpl functionReturn, ProcedureParameterMetadata parameterMetadata, ProcedureParamBindings paramBindings, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public String renderCallableStatement(String procedureName, JdbcCall jdbcCall, ProcedureParamBindings paramBindings, SharedSessionContractImplementor session) {
        int startIndex;
        boolean firstParamIsRefCursor;
        boolean bl = firstParamIsRefCursor = !jdbcCall.getParameterRegistrations().isEmpty() && jdbcCall.getParameterRegistrations().get(0).getParameterMode() == ParameterMode.REF_CURSOR;
        if (firstParamIsRefCursor && paramBindings.getParameterMetadata().getParameterStrategy() == ParameterStrategy.NAMED) {
            throw new HibernateException("Cannot mix named parameters and REF_CURSOR parameter on PostgreSQL");
        }
        StringBuilder buffer = firstParamIsRefCursor ? new StringBuilder().append("{? = call ") : new StringBuilder().append("{call ");
        buffer.append(procedureName).append("(");
        String sep = "";
        for (int i = startIndex = firstParamIsRefCursor ? 1 : 0; i < jdbcCall.getParameterRegistrations().size(); ++i) {
            JdbcCallParameterRegistration parameter = jdbcCall.getParameterRegistrations().get(i);
            if (parameter.getParameterMode() == ParameterMode.REF_CURSOR) {
                throw new HibernateException("PostgreSQL supports only one REF_CURSOR parameter, but multiple were registered");
            }
            int max = parameter.getParameterType().getNumberOfJdbcParametersNeeded();
            for (int x = 0; x < max; ++x) {
                buffer.append(sep).append("?");
                sep = ",";
            }
        }
        return buffer.append(")}").toString();
    }
}

