/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.ParameterMode;
import javax.persistence.PersistenceException;
import javax.persistence.TemporalType;
import javax.persistence.TransactionRequiredException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.procedure.NoSuchParameterException;
import org.hibernate.procedure.ParameterMisuseException;
import org.hibernate.procedure.ParameterStrategyException;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.ProcedureOutputs;
import org.hibernate.procedure.internal.FunctionReturnImpl;
import org.hibernate.procedure.internal.ProcedureOutputsImpl;
import org.hibernate.procedure.internal.ProcedureParameterImpl;
import org.hibernate.procedure.internal.Util;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParamBindings;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.procedure.spi.ProcedureParameterMetadata;
import org.hibernate.query.Query;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.AbstractQuery;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.named.internal.NamedCallableQueryMementoImpl;
import org.hibernate.query.named.spi.NamedCallableQueryMemento;
import org.hibernate.query.named.spi.ParameterMemento;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.result.NoMoreOutputsException;
import org.hibernate.result.Output;
import org.hibernate.result.ResultSetOutput;
import org.hibernate.result.UpdateCountOutput;
import org.hibernate.result.internal.ResultContext;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.ResultSetMappingDescriptor;
import org.hibernate.type.Type;

public class ProcedureCallImpl<R>
extends AbstractQuery<R>
implements ProcedureCallImplementor<R>,
ResultContext {
    private final String procedureName;
    private FunctionReturnImpl functionReturn;
    private final ProcedureParameterMetadata parameterMetadata;
    private final ProcedureParamBindings paramBindings;
    private final List<List<DomainResult>> resultListList;
    private Set<String> synchronizedQuerySpaces;
    private ProcedureOutputsImpl outputs;
    private final QueryOptionsImpl queryOptions = new QueryOptionsImpl();
    private ProcedureOutputs procedureResult;

    public ProcedureCallImpl(SharedSessionContractImplementor session, String procedureName) {
        super(session);
        this.procedureName = procedureName;
        this.parameterMetadata = new ProcedureParameterMetadata(this);
        this.paramBindings = new ProcedureParamBindings(this.parameterMetadata, this);
        this.synchronizedQuerySpaces = null;
        this.resultListList = null;
    }

    public ProcedureCallImpl(SharedSessionContractImplementor session, String procedureName, Class ... resultClasses) {
        super(session);
        assert (resultClasses != null && resultClasses.length > 0);
        this.procedureName = procedureName;
        this.parameterMetadata = new ProcedureParameterMetadata(this);
        this.paramBindings = new ProcedureParamBindings(this.parameterMetadata, this);
        HashSet<String> querySpaces = new HashSet<String>();
        if (resultClasses.length == 1) {
            ArrayList collectedDomainResults = new ArrayList();
            Util.resolveResultClass(resultClasses[0], querySpaces::addAll, collectedDomainResults::add, (SessionFactoryImplementor)session.getSessionFactory());
            this.resultListList = Collections.singletonList(collectedDomainResults);
        } else {
            this.resultListList = CollectionHelper.arrayList(resultClasses.length);
            for (Class resultClass : resultClasses) {
                ArrayList collectedDomainResults = new ArrayList();
                Util.resolveResultClass(resultClass, querySpaces::addAll, collectedDomainResults::add, (SessionFactoryImplementor)session.getSessionFactory());
                this.resultListList.add(collectedDomainResults);
            }
        }
        this.synchronizedQuerySpaces = querySpaces;
    }

    public ProcedureCallImpl(SharedSessionContractImplementor session, String procedureName, String ... resultSetMappingNames) {
        super(session);
        assert (resultSetMappingNames != null && resultSetMappingNames.length > 0);
        this.procedureName = procedureName;
        this.parameterMetadata = new ProcedureParameterMetadata(this);
        this.paramBindings = new ProcedureParamBindings(this.parameterMetadata, this);
        HashSet querySpaces = new HashSet();
        if (resultSetMappingNames.length == 1) {
            ArrayList collectedDomainResults = new ArrayList();
            Util.resolveResultSetMapping(resultSetMappingNames[0], querySpaces::addAll, collectedDomainResults::add, (SessionFactoryImplementor)session.getSessionFactory());
            this.resultListList = Collections.singletonList(collectedDomainResults);
        } else {
            this.resultListList = CollectionHelper.arrayList(resultSetMappingNames.length);
            for (String resultSetMappingName : resultSetMappingNames) {
                ArrayList collectedDomainResults = new ArrayList();
                Util.resolveResultSetMapping(resultSetMappingName, querySpaces::addAll, collectedDomainResults::add, (SessionFactoryImplementor)session.getSessionFactory());
                this.resultListList.add(collectedDomainResults);
            }
        }
        this.synchronizedQuerySpaces = Collections.unmodifiableSet(querySpaces);
    }

    public static ProcedureCallImpl fromMemento(NamedCallableQueryMemento memento, SharedSessionContractImplementor session) {
        ProcedureCallImpl procedureCall = memento.getResultClasses().length > 0 ? new ProcedureCallImpl(session, memento.getCallableName(), memento.getResultClasses()) : (memento.getResultSetMappingNames().length > 0 ? new ProcedureCallImpl(session, memento.getCallableName(), memento.getResultSetMappingNames()) : new ProcedureCallImpl(session, memento.getCallableName()));
        if (!memento.getQuerySpaces().isEmpty()) {
            if (procedureCall.synchronizedQuerySpaces == null) {
                procedureCall.synchronizedQuerySpaces = new HashSet<String>();
            }
            procedureCall.synchronizedQuerySpaces.addAll(memento.getQuerySpaces());
        }
        memento.getHints().forEach((string, object) -> this.setHint((String)string, object));
        return procedureCall;
    }

    @Override
    public String getProcedureName() {
        return this.procedureName;
    }

    @Override
    public ProcedureParameterMetadata getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.paramBindings;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public boolean isFunctionCall() {
        return this.functionReturn != null;
    }

    @Override
    public ProcedureCall markAsFunctionCall(int sqlType) {
        this.functionReturn = new FunctionReturnImpl((ProcedureCallImplementor)this, sqlType);
        return this;
    }

    public ProcedureParameterImplementor registerParameter(int position, Class type, ParameterMode mode) {
        ProcedureParameterImpl procedureParameter = new ProcedureParameterImpl(position, mode, type, this.getSession().getFactory().getTypeConfiguration().getBasicTypeRegistry().getBasicType(type), false);
        this.parameterMetadata.registerParameter(procedureParameter);
        return procedureParameter;
    }

    public ProcedureCall registerParameter0(int position, Class type, ParameterMode mode) {
        this.registerParameter(position, type, mode);
        return this;
    }

    @Override
    public ProcedureParameterImplementor getParameterRegistration(int position) {
        return this.getParameterMetadata().getQueryParameter(position);
    }

    public ProcedureParameterImplementor registerParameter(String name, Class type, ParameterMode mode) {
        ProcedureParameterImpl procedureParameter = new ProcedureParameterImpl(name, mode, type, this.getSession().getFactory().getTypeConfiguration().getBasicTypeRegistry().getBasicType(type), false);
        this.parameterMetadata.registerParameter(procedureParameter);
        return procedureParameter;
    }

    @Override
    public ProcedureCall registerParameter0(String name, Class type, ParameterMode mode) {
        this.registerParameter(name, type, mode);
        return this;
    }

    @Override
    public ProcedureParameterImplementor getParameterRegistration(String name) {
        return this.getParameterMetadata().getQueryParameter(name);
    }

    public List getRegisteredParameters() {
        return new ArrayList(this.getParameterMetadata().collectAllParameters());
    }

    @Override
    public ProcedureOutputs getOutputs() {
        if (this.outputs == null) {
            this.outputs = this.buildOutputs();
        }
        return this.outputs;
    }

    private ProcedureOutputsImpl buildOutputs() {
        this.paramBindings.validate();
        if (this.isFunctionCall() && this.parameterMetadata.getParameterCount() <= 0) {
            throw new IllegalStateException("A function call was requested, but no parameter registrations were made; at least need to register the function result param");
        }
        CallableStatementSupport callableStatementSupport = this.getSession().getFactory().getJdbcServices().getJdbcEnvironment().getDialect().getCallableStatementSupport();
        return new ProcedureOutputsImpl(this, callableStatementSupport.interpretCall(this.getProcedureName(), this.functionReturn, this.parameterMetadata, this.paramBindings, this.getSession()), this.parameterMetadata.getParameterStrategy(), this.queryOptions, this.paramBindings, this.getSession());
    }

    @Override
    public String getQueryString() {
        return this.getProcedureName() + "(...)";
    }

    @Override
    public Query<R> applyGraph(RootGraph<?> graph, GraphSemantic semantic) {
        this.queryOptions.applyGraph((RootGraphImplementor)graph, semantic);
        return this;
    }

    protected Set<String> synchronizedQuerySpaces() {
        return this.synchronizedQuerySpaces == null ? Collections.emptySet() : this.synchronizedQuerySpaces;
    }

    @Override
    public Set<String> getSynchronizedQuerySpaces() {
        if (this.synchronizedQuerySpaces == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.synchronizedQuerySpaces);
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedQuerySpace(String querySpace) {
        this.synchronizedQuerySpaces().add(querySpace);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedEntityName(String entityName) {
        this.addSynchronizedQuerySpaces(this.getSession().getFactory().getMetamodel().findEntityDescriptor(entityName));
        return this;
    }

    protected void addSynchronizedQuerySpaces(EntityTypeDescriptor<?> descriptor) {
        this.synchronizedQuerySpaces().addAll(descriptor.getAffectedTableNames());
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedEntityClass(Class entityClass) {
        this.addSynchronizedQuerySpaces(this.getSession().getFactory().getMetamodel().findEntityDescriptor(entityClass.getName()));
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(int position, Class type, ParameterMode mode) {
        this.getSession().checkOpen(true);
        try {
            this.registerParameter(position, type, mode);
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(String parameterName, Class type, ParameterMode mode) {
        this.getSession().checkOpen(true);
        try {
            this.registerParameter(parameterName, type, mode);
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    public boolean execute() {
        try {
            Output rtn = this.outputs().getCurrent();
            return ResultSetOutput.class.isInstance(rtn);
        }
        catch (NoMoreOutputsException e) {
            return false;
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
    }

    protected ProcedureOutputs outputs() {
        if (this.procedureResult == null) {
            this.procedureResult = this.getOutputs();
        }
        return this.procedureResult;
    }

    @Override
    protected int doExecuteUpdate() {
        if (!this.getSession().isTransactionInProgress()) {
            throw new TransactionRequiredException("javax.persistence.Query.executeUpdate requires active transaction");
        }
        try {
            this.execute();
            int n = this.getUpdateCount();
            return n;
        }
        finally {
            this.outputs().release();
        }
    }

    public Object getOutputParameterValue(int position) {
        try {
            return this.outputs().getOutputParameterValue(position);
        }
        catch (ParameterStrategyException e) {
            throw new IllegalArgumentException("Invalid mix of named and positional parameters", (Throwable)((Object)e));
        }
        catch (NoSuchParameterException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public Object getOutputParameterValue(String parameterName) {
        try {
            return this.outputs().getOutputParameterValue(parameterName);
        }
        catch (ParameterStrategyException e) {
            throw new IllegalArgumentException("Invalid mix of named and positional parameters", (Throwable)((Object)e));
        }
        catch (NoSuchParameterException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public boolean hasMoreResults() {
        return this.outputs().goToNext() && ResultSetOutput.class.isInstance(this.outputs().getCurrent());
    }

    public int getUpdateCount() {
        try {
            Output rtn = this.outputs().getCurrent();
            if (rtn == null) {
                return -1;
            }
            if (UpdateCountOutput.class.isInstance(rtn)) {
                return ((UpdateCountOutput)rtn).getUpdateCount();
            }
            return -1;
        }
        catch (NoMoreOutputsException e) {
            return -1;
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
    }

    @Override
    protected List<R> doList() {
        if (this.getMaxResults() == 0) {
            return Collections.EMPTY_LIST;
        }
        try {
            Output rtn = this.outputs().getCurrent();
            if (!ResultSetOutput.class.isInstance(rtn)) {
                throw new IllegalStateException("Current CallableStatement ou was not a ResultSet, but getResultList was called");
            }
            return ((ResultSetOutput)rtn).getResultList();
        }
        catch (NoMoreOutputsException e) {
            return null;
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
    }

    @Override
    protected ScrollableResultsImplementor doScroll(ScrollMode scrollMode) {
        throw new UnsupportedOperationException("Query#scroll is not valid for ProcedureCall/StoredProcedureQuery");
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isInstance(this)) {
            return (T)this;
        }
        if (cls.isInstance(this.parameterMetadata)) {
            return (T)this.parameterMetadata;
        }
        if (cls.isInstance(this.paramBindings)) {
            return (T)this.paramBindings;
        }
        if (cls.isInstance(this.queryOptions)) {
            return (T)this.queryOptions;
        }
        if (cls.isInstance(this.getSession())) {
            return (T)this.getSession();
        }
        if (ProcedureOutputs.class.isAssignableFrom(cls)) {
            return (T)this.getOutputs();
        }
        throw new PersistenceException("Unrecognized unwrap type : " + cls.getName());
    }

    @Override
    public ProcedureCallImplementor<R> setHint(String hintName, Object value) {
        if ("hibernate.procedure.function_return_jdbc_type_code".equals(hintName)) {
            this.markAsFunctionCall(ConfigurationHelper.getInteger(value));
        }
        super.setHint(hintName, value);
        return this;
    }

    @Override
    protected void applyEntityGraphQueryHint(String hintName, RootGraphImplementor entityGraph) {
        throw new IllegalStateException("EntityGraph hints are not supported for ProcedureCall/StoredProcedureQuery");
    }

    @Override
    protected boolean canApplyAliasSpecificLockModes() {
        return false;
    }

    @Override
    protected void verifySettingLockMode() {
        throw new IllegalStateException("Illegal attempt to set lock mode on a ProcedureCall / StoredProcedureQuery");
    }

    @Override
    protected void verifySettingAliasSpecificLockModes() {
        throw new IllegalStateException("Illegal attempt to set lock mode on a ProcedureCall / StoredProcedureQuery");
    }

    @Override
    public ProcedureCallImplementor<R> setLockMode(LockModeType lockMode) {
        throw new IllegalStateException("javax.persistence.Query.setLockMode not valid on javax.persistence.StoredProcedureQuery");
    }

    @Override
    public LockModeType getLockMode() {
        throw new IllegalStateException("javax.persistence.Query.getLockMode not valid on javax.persistence.StoredProcedureQuery");
    }

    @Override
    public ProcedureCallImplementor<R> setFlushMode(FlushModeType flushModeType) {
        super.setFlushMode(flushModeType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(int position, Collection values) {
        throw new ParameterMisuseException("ProcedureCall/StoredProcedureQuery parameters cannot be multi-valued");
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(int position, Collection values, Type type) {
        throw new ParameterMisuseException("ProcedureCall/StoredProcedureQuery parameters cannot be multi-valued");
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(int position, Object[] values, Type type) {
        throw new ParameterMisuseException("ProcedureCall/StoredProcedureQuery parameters cannot be multi-valued");
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(int position, Object[] values) {
        throw new ParameterMisuseException("ProcedureCall/StoredProcedureQuery parameters cannot be multi-valued");
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(Parameter<Instant> param, Instant value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(Parameter<LocalDateTime> param, LocalDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(Parameter<ZonedDateTime> param, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(Parameter<OffsetDateTime> param, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, LocalDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, LocalDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter((QueryParameter)parameter, (Object)value);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P value, AllowableParameterType type) {
        super.setParameter((QueryParameter)parameter, (Object)value, type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Object value, AllowableParameterType type) {
        super.setParameter(name, value, type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Object value, AllowableParameterType type) {
        super.setParameter(position, value, type);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P value, TemporalType temporalType) {
        super.setParameter((QueryParameter)parameter, (Object)value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Object value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Object value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<P> values) {
        super.setParameterList((QueryParameter)parameter, (Collection)values);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(String name, Collection values, AllowableParameterType type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(int position, Collection values, AllowableParameterType type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(String name, Object[] values, AllowableParameterType type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(int position, Object[] values, AllowableParameterType type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(String name, Collection values, Class type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(int position, Collection values, Class type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NamedCallableQueryMemento toMemento(String name, SessionFactoryImplementor factory) {
        return new NamedCallableQueryMementoImpl(name, this.procedureName, this.getParameterMetadata().getParameterStrategy(), ProcedureCallImpl.toParameterMementos(this.getParameterMetadata()), null, this.synchronizedQuerySpaces, this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getHibernateFlushMode(), this.isReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), Util.copy(this.getHints()));
    }

    private static List<ParameterMemento> toParameterMementos(ProcedureParameterMetadata<ProcedureParameterImplementor<?>> parameterMetadata) {
        if (parameterMetadata.getParameterStrategy() == ParameterStrategy.UNKNOWN) {
            return Collections.emptyList();
        }
        ArrayList<ParameterMemento> copy = new ArrayList<ParameterMemento>();
        parameterMetadata.visitRegistrations(queryParameter -> copy.add(queryParameter.toMemento()));
        return copy;
    }

    @Override
    public DomainParameterBindingContext getDomainParameterBindingContext() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public Callback getCallback() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public List<ResultSetMappingDescriptor> getResultSetMappings() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public JDBCException convertException(SQLException e, String message) {
        throw new NotYetImplementedFor6Exception();
    }
}

