/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.JDBCException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.procedure.ProcedureOutputs;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureParamBindings;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.result.Output;
import org.hibernate.result.internal.OutputsImpl;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.exec.internal.JdbcCallRefCursorExtractorImpl;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcCall;
import org.hibernate.sql.exec.spi.JdbcCallParameterExtractor;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcCallRefCursorExtractor;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.jboss.logging.Logger;

public class ProcedureOutputsImpl
extends OutputsImpl
implements ProcedureOutputs,
ExecutionContext,
DomainParameterBindingContext,
Callback {
    private static final Logger log = Logger.getLogger(ProcedureOutputsImpl.class);
    private final ParameterStrategy parameterStrategy;
    private final QueryOptions queryOptions;
    private final SharedSessionContractImplementor session;
    private final ProcedureCallImpl procedureCall;
    private final JdbcCall jdbcCall;
    private final String callableName;
    private final String callString;
    private final CallableStatement callableStatement;
    private Map<String, JdbcCallParameterExtractor> parameterExtractorMap;
    private Iterator<JdbcCallRefCursorExtractor> refCursorExtractorIterator;

    ProcedureOutputsImpl(ProcedureCallImpl procedureCall, JdbcCall jdbcCall, ParameterStrategy parameterStrategy, QueryOptions queryOptions, ProcedureParamBindings bindings, SharedSessionContractImplementor session) {
        super(procedureCall);
        this.parameterStrategy = parameterStrategy;
        this.queryOptions = queryOptions;
        this.session = session;
        this.procedureCall = procedureCall;
        this.jdbcCall = jdbcCall;
        this.callableName = jdbcCall.getSql();
        this.callString = this.buildCallableString(bindings);
        this.callableStatement = this.prepareCallableStatement(queryOptions, bindings);
        this.prime(this.callableStatement);
        this.refCursorExtractorIterator = jdbcCall.getCallRefCursorExtractors().iterator();
    }

    private String buildCallableString(ProcedureParamBindings bindings) {
        CallableStatementSupport callableStatementSupport = this.session.getJdbcServices().getJdbcEnvironment().getDialect().getCallableStatementSupport();
        return callableStatementSupport.renderCallableStatement(this.callableName, this.jdbcCall, bindings, this.session);
    }

    private CallableStatement prepareCallableStatement(QueryOptions queryOptions, QueryParameterBindings bindings) {
        try {
            log.debugf("Preparing procedure/function call (%s) : %s", (Object)this.jdbcCall.getSql(), (Object)this.callString);
            CallableStatement callableStatement = (CallableStatement)this.session.getJdbcCoordinator().getStatementPreparer().prepareStatement(this.callString, true);
            ArrayList<JdbcCallRefCursorExtractorImpl> refCursorExtractors = null;
            if (this.jdbcCall.getFunctionReturn() != null) {
                this.jdbcCall.getFunctionReturn().registerParameter(callableStatement, this.session);
                JdbcCallParameterExtractor parameterExtractor = this.jdbcCall.getFunctionReturn().getParameterExtractor();
                JdbcCallRefCursorExtractorImpl refCursorExtractor = this.jdbcCall.getFunctionReturn().getRefCursorExtractor();
                if (parameterExtractor != null) {
                    assert (refCursorExtractor == null);
                    String key = parameterExtractor.getParameterName() == null ? Integer.toString(parameterExtractor.getParameterPosition()) : parameterExtractor.getParameterName();
                    this.parameterExtractorMap = new HashMap<String, JdbcCallParameterExtractor>();
                    this.parameterExtractorMap.put(key, parameterExtractor);
                } else if (refCursorExtractor != null) {
                    refCursorExtractors = new ArrayList<JdbcCallRefCursorExtractorImpl>();
                    refCursorExtractors.add(refCursorExtractor);
                }
            }
            for (JdbcCallParameterRegistration registration : this.jdbcCall.getParameterRegistrations()) {
                int jdbcPosition = 1;
                registration.registerParameter(callableStatement, this.session);
                JdbcParameterBinder binder = registration.getParameterBinder();
                if (binder != null) {
                    binder.bindParameterValue(callableStatement, jdbcPosition, JdbcParameterBindings.NO_BINDINGS, this);
                }
                JdbcCallParameterExtractor parameterExtractor = registration.getParameterExtractor();
                JdbcCallRefCursorExtractorImpl refCursorExtractor = registration.getRefCursorExtractor();
                if (parameterExtractor != null) {
                    assert (refCursorExtractor == null);
                    if (this.parameterExtractorMap == null) {
                        this.parameterExtractorMap = new HashMap<String, JdbcCallParameterExtractor>();
                    }
                    String key = parameterExtractor.getParameterName() == null ? Integer.toString(parameterExtractor.getParameterPosition()) : parameterExtractor.getParameterName();
                    this.parameterExtractorMap.put(key, parameterExtractor);
                    continue;
                }
                if (refCursorExtractors == null) {
                    refCursorExtractors = new ArrayList();
                }
                refCursorExtractors.add(refCursorExtractor);
            }
            this.refCursorExtractorIterator = refCursorExtractors == null ? Collections.emptyIterator() : refCursorExtractors.iterator();
            return callableStatement;
        }
        catch (SQLException e) {
            throw this.session.getJdbcServices().getSqlExceptionHelper().convert(e, "Error preparing CallableStatement [" + this.jdbcCall.getSql() + "]", this.callString);
        }
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.procedureCall.getSession().getFactory();
    }

    @Override
    protected boolean nextResult() throws SQLException {
        return this.callableStatement.getMoreResults();
    }

    @Override
    protected OutputsImpl.CurrentReturnState buildCurrentReturnState(boolean isResultSet) throws SQLException {
        return this.buildCurrentReturnState(isResultSet, this.callableStatement);
    }

    @Override
    protected OutputsImpl.CurrentReturnState buildCurrentReturnState(boolean isResultSet, int updateCount, PreparedStatement jdbcStatement) {
        return new OutputsImpl.CurrentReturnState(isResultSet, updateCount, jdbcStatement){

            @Override
            protected boolean hasExtendedReturns() {
                return !ProcedureOutputsImpl.this.jdbcCall.getCallRefCursorExtractors().isEmpty();
            }

            @Override
            protected Output buildExtendedReturn() {
                JdbcCallRefCursorExtractor extractor = (JdbcCallRefCursorExtractor)ProcedureOutputsImpl.this.refCursorExtractorIterator.next();
                ResultSet resultSet = extractor.extractResultSet(ProcedureOutputsImpl.this.callableStatement, ProcedureOutputsImpl.this.session);
                return this.buildResultSetOutput(ProcedureOutputsImpl.this.extractResults(resultSet, ProcedureOutputsImpl.this.callableStatement));
            }
        };
    }

    private JDBCException convert(SQLException e, String message) {
        return this.session.getJdbcServices().getSqlExceptionHelper().convert(e, message, this.callString);
    }

    @Override
    public <T> T getOutputParameterValue(ProcedureParameterImplementor<T> parameterRegistration) {
        JdbcCallParameterExtractor extractor = this.resolveJdbcParameterExtractor(parameterRegistration);
        return extractor.extractValue(this.callableStatement, this.parameterStrategy == ParameterStrategy.NAMED, this);
    }

    private <T> JdbcCallParameterExtractor resolveJdbcParameterExtractor(ProcedureParameterImplementor<T> parameterRegistration) {
        String key = parameterRegistration.getName() != null ? parameterRegistration.getName() : Integer.toString(parameterRegistration.getPosition());
        JdbcCallParameterExtractor extractor = this.parameterExtractorMap.get(key);
        if (extractor == null) {
            throw new AssertionFailure("Could not locate JdbcParameterExtractor for given ParameterRegistration :  " + parameterRegistration);
        }
        return extractor;
    }

    @Override
    public Object getOutputParameterValue(String name) {
        return this.getOutputParameterValue(this.procedureCall.getParameterRegistration(name));
    }

    @Override
    public Object getOutputParameterValue(int position) {
        return this.getOutputParameterValue(this.procedureCall.getParameterRegistration(position));
    }

    @Override
    public void release() {
        try {
            this.callableStatement.close();
        }
        catch (SQLException e) {
            log.debug((Object)"Unable to close PreparedStatement", (Throwable)e);
        }
    }

    @Override
    public <T> List<T> getLoadIdentifiers() {
        return Collections.emptyList();
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.procedureCall.getQueryParameterBindings();
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        return this.session;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public DomainParameterBindingContext getDomainParameterBindingContext() {
        return this;
    }

    @Override
    public Callback getCallback() {
        return this;
    }

    @Override
    public void registerAfterLoadAction(AfterLoadAction afterLoadAction) {
    }
}

