/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.Objects;
import javax.persistence.ParameterMode;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.AbstractQueryParameter;
import org.hibernate.query.named.spi.ParameterMemento;

public class ProcedureParameterImpl<T>
extends AbstractQueryParameter<T>
implements ProcedureParameterImplementor<T> {
    private final String name;
    private final Integer position;
    private final ParameterMode mode;
    private final Class<T> javaType;

    public ProcedureParameterImpl(String name, ParameterMode mode, Class<T> javaType, AllowableParameterType<T> hibernateType, boolean passNulls) {
        super(false, hibernateType);
        this.name = name;
        this.position = null;
        this.mode = mode;
        this.javaType = javaType;
    }

    public ProcedureParameterImpl(Integer position, ParameterMode mode, Class<T> javaType, AllowableParameterType<T> hibernateType, boolean passNulls) {
        super(false, hibernateType);
        this.name = null;
        this.position = position;
        this.mode = mode;
        this.javaType = javaType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public ParameterMode getMode() {
        return this.mode;
    }

    @Override
    public Class<T> getParameterType() {
        return this.javaType;
    }

    @Override
    public ParameterMemento toMemento() {
        return new ParameterMemento(){

            @Override
            public QueryParameter toQueryParameter(SharedSessionContractImplementor session) {
                if (ProcedureParameterImpl.this.getName() != null) {
                    return new ProcedureParameterImpl(ProcedureParameterImpl.this.getName(), ProcedureParameterImpl.this.getMode(), ProcedureParameterImpl.this.javaType, ProcedureParameterImpl.this.getHibernateType(), session.getFactory().getSessionFactoryOptions().isProcedureParameterNullPassingEnabled());
                }
                return new ProcedureParameterImpl(ProcedureParameterImpl.this.getPosition(), ProcedureParameterImpl.this.getMode(), ProcedureParameterImpl.this.javaType, ProcedureParameterImpl.this.getHibernateType(), session.getFactory().getSessionFactoryOptions().isProcedureParameterNullPassingEnabled());
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcedureParameterImpl that = (ProcedureParameterImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.position, that.position) && this.mode == that.mode;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.position, this.mode);
    }
}

