/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.function.Consumer;
import javax.persistence.ParameterMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.procedure.ParameterMisuseException;
import org.hibernate.procedure.internal.FunctionReturnImpl;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureParamBindings;
import org.hibernate.procedure.spi.ProcedureParameterBindingImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.procedure.spi.ProcedureParameterMetadata;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.sql.exec.internal.JdbcCallImpl;
import org.hibernate.sql.exec.internal.JdbcCallParameterBinderImpl;
import org.hibernate.sql.exec.internal.JdbcCallParameterExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcCallParameterRegistrationImpl;
import org.hibernate.sql.exec.internal.JdbcCallRefCursorExtractorImpl;
import org.hibernate.sql.exec.spi.JdbcCall;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;

public class StandardCallableStatementSupport
implements CallableStatementSupport {
    public static final StandardCallableStatementSupport NO_REF_CURSOR_INSTANCE = new StandardCallableStatementSupport(false);
    public static final StandardCallableStatementSupport REF_CURSOR_INSTANCE = new StandardCallableStatementSupport(true);
    private final boolean supportsRefCursors;

    public StandardCallableStatementSupport(boolean supportsRefCursors) {
        this.supportsRefCursors = supportsRefCursors;
    }

    @Override
    public JdbcCall interpretCall(final String procedureName, final FunctionReturnImpl functionReturn, ProcedureParameterMetadata parameterMetadata, final ProcedureParamBindings paramBindings, final SharedSessionContractImplementor session) {
        final JdbcCallImpl.Builder jdbcCallBuilder = new JdbcCallImpl.Builder(procedureName, parameterMetadata.getParameterStrategy());
        if (functionReturn != null) {
            jdbcCallBuilder.setFunctionReturn(functionReturn.toJdbcFunctionReturn(session));
        }
        parameterMetadata.visitRegistrations(new Consumer<ProcedureParameterImplementor<?>>(){
            int parameterPosition;
            {
                this.parameterPosition = functionReturn == null ? 0 : 1;
            }

            @Override
            public void accept(ProcedureParameterImplementor<?> queryParameter) {
                JdbcCallParameterRegistrationImpl jdbcRegistration;
                QueryParameterBinding binding = paramBindings.getBinding(queryParameter);
                if (queryParameter.getMode() == ParameterMode.REF_CURSOR) {
                    jdbcRegistration = new JdbcCallParameterRegistrationImpl(queryParameter.getName(), this.parameterPosition, ParameterMode.REF_CURSOR, 2012, null, null, null, new JdbcCallRefCursorExtractorImpl(queryParameter.getName(), this.parameterPosition));
                } else {
                    AllowableParameterType ormType = StandardCallableStatementSupport.this.determineTypeToUse(queryParameter, (ProcedureParameterBindingImplementor)binding);
                    if (ormType == null) {
                        throw new ParameterMisuseException("Could not determine Hibernate Type for parameter : " + queryParameter);
                    }
                    JdbcCallParameterBinderImpl parameterBinder = null;
                    JdbcCallParameterExtractorImpl parameterExtractor = null;
                    if (queryParameter.getMode() == ParameterMode.IN || queryParameter.getMode() == ParameterMode.INOUT) {
                        parameterBinder = new JdbcCallParameterBinderImpl(procedureName, queryParameter.getName(), queryParameter.getPosition(), ormType, session.getFactory().getTypeConfiguration());
                    }
                    if (queryParameter.getMode() == ParameterMode.OUT || queryParameter.getMode() == ParameterMode.INOUT) {
                        parameterExtractor = new JdbcCallParameterExtractorImpl(procedureName, queryParameter.getName(), queryParameter.getPosition(), ormType);
                    }
                    jdbcRegistration = new JdbcCallParameterRegistrationImpl(queryParameter.getName(), this.parameterPosition, ParameterMode.REF_CURSOR, 2012, ormType, parameterBinder, parameterExtractor, null);
                }
                jdbcCallBuilder.addParameterRegistration(jdbcRegistration);
                ++this.parameterPosition;
            }
        });
        return jdbcCallBuilder.buildJdbcCall();
    }

    protected AllowableParameterType determineTypeToUse(ProcedureParameterImplementor parameter, ProcedureParameterBindingImplementor binding) {
        if (binding != null && binding.isBound() && binding.getBindType() != null) {
            return binding.getBindType();
        }
        if (parameter.getHibernateType() != null) {
            return parameter.getHibernateType();
        }
        return null;
    }

    @Override
    public String renderCallableStatement(String procedureName, JdbcCall jdbcCall, ProcedureParamBindings paramBindings, SharedSessionContractImplementor session) {
        int startIndex;
        boolean renderAsFunctionCall;
        boolean bl = renderAsFunctionCall = jdbcCall.getFunctionReturn() != null;
        if (renderAsFunctionCall && paramBindings.getParameterMetadata().getParameterStrategy() == ParameterStrategy.NAMED) {
            throw new HibernateException("Cannot mix named parameters and REF_CURSOR parameter");
        }
        StringBuilder buffer = renderAsFunctionCall ? new StringBuilder().append("{? = call ") : new StringBuilder().append("{call ");
        buffer.append(procedureName).append("(");
        String sep = "";
        for (int i = startIndex = renderAsFunctionCall ? 1 : 0; i < jdbcCall.getParameterRegistrations().size(); ++i) {
            JdbcCallParameterRegistration registration = jdbcCall.getParameterRegistrations().get(i);
            if (registration.getParameterMode() == ParameterMode.REF_CURSOR && !this.supportsRefCursors) {
                throw new HibernateException("Found REF_CURSOR parameter registration, but database does not support REF_CURSOR parameters");
            }
            buffer.append(sep).append("?");
        }
        return buffer.append(")}").toString();
    }
}

