/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.procedure.UnknownSqlResultSetMappingException;
import org.hibernate.query.spi.ResultSetMappingDescriptor;
import org.hibernate.query.sql.spi.ResolvingSqlSelectionImpl;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.internal.domain.entity.EntityResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.EntityJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.spi.BasicType;
import org.jboss.logging.Logger;

public class Util {
    private static final Logger log = Logger.getLogger(Util.class);

    private Util() {
    }

    public static Set<String> copy(Set<String> synchronizedQuerySpaces) {
        return CollectionHelper.makeCopy(synchronizedQuerySpaces);
    }

    public static Map<String, Object> copy(Map<String, Object> hints) {
        return CollectionHelper.makeCopy(hints);
    }

    public static void resolveResultSetMapping(String resultSetMappingName, Consumer<Collection<String>> querySpacesConsumer, Consumer<DomainResult> resultConsumer, SessionFactoryImplementor sessionFactory) {
        new QueryReturnResolver(sessionFactory, querySpacesConsumer, resultConsumer).resolve(resultSetMappingName);
    }

    public static void resolveResultClass(Class resultType, Consumer<Collection<String>> querySpacesConsumer, Consumer<DomainResult> resultConsumer, SessionFactoryImplementor sessionFactory) {
        JavaTypeDescriptor resultTypeDescriptor = sessionFactory.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(resultType);
        if (resultTypeDescriptor instanceof BasicJavaDescriptor) {
            BasicType basicType = sessionFactory.getTypeConfiguration().getBasicTypeRegistry().getBasicType(resultType);
            SqlExpressableType sqlExpressableType = basicType.getSqlExpressableType(sessionFactory.getTypeConfiguration());
            resultConsumer.accept(new BasicResultImpl(null, new ResolvingSqlSelectionImpl(1, sqlExpressableType), sqlExpressableType));
        } else if (resultTypeDescriptor instanceof EntityJavaDescriptor) {
            EntityTypeDescriptor entityDescriptor = sessionFactory.getMetamodel().getEntityDescriptor(resultType.getName());
            querySpacesConsumer.accept(entityDescriptor.getAffectedTableNames());
            resultConsumer.accept(new EntityResultImpl(null, null, null, null));
        }
        throw new NotYetImplementedFor6Exception();
    }

    private static class QueryReturnResolver {
        private final SessionFactoryImplementor sessionFactory;
        private final Consumer<Collection<String>> querySpacesConsumer;
        private final Consumer<DomainResult> resultConsumer;
        private int selectablesCount = 0;
        Map<String, SqlSelection> sqlSelectionMap = new HashMap<String, SqlSelection>();
        Map<String, FetchParent> fetchParentMap = null;

        public QueryReturnResolver(SessionFactoryImplementor sessionFactory, Consumer<Collection<String>> querySpacesConsumer, Consumer<DomainResult> resultConsumer) {
            this.sessionFactory = sessionFactory;
            this.querySpacesConsumer = querySpacesConsumer;
            this.resultConsumer = resultConsumer;
        }

        public void resolve(String resultSetMappingName) {
            log.tracef("Starting attempt to resolve named result-set-mapping : %s", (Object)resultSetMappingName);
            ResultSetMappingDescriptor mapping = this.sessionFactory.getQueryEngine().getNamedQueryRepository().getResultSetMappingDescriptor(resultSetMappingName);
            if (mapping == null) {
                throw new UnknownSqlResultSetMappingException("Unknown SqlResultSetMapping [" + resultSetMappingName + "]");
            }
            log.tracef("Found result-set-mapping : %s", (Object)mapping.getName());
            throw new NotYetImplementedFor6Exception();
        }

        private JavaTypeDescriptor resolveJavaTypeDescriptor(Class javaType) {
            return this.sessionFactory.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(javaType);
        }
    }

    public static interface ResultSetMappingResolutionContext {
        public SqlAstCreationContext getSqlAstCreationContext();

        public ResultSetMappingDescriptor findResultSetMapping(String var1);

        public void addQueryReturns(DomainResult ... var1);

        public void addQuerySpaces(String ... var1);
    }
}

