/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.persistence.ParameterMode;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.procedure.internal.ProcedureParameterBindingImpl;
import org.hibernate.procedure.spi.ProcedureParameterBindingImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.procedure.spi.ProcedureParameterMetadata;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;

public class ProcedureParamBindings
implements QueryParameterBindings<ProcedureParameterBindingImplementor<?>> {
    private final ProcedureParameterMetadata parameterMetadata;
    private final ProcedureCallImpl procedureCall;
    private final Map<ProcedureParameterImplementor, ProcedureParameterBindingImplementor> bindingMap = new HashMap<ProcedureParameterImplementor, ProcedureParameterBindingImplementor>();

    public ProcedureParamBindings(ProcedureParameterMetadata parameterMetadata, ProcedureCallImpl procedureCall) {
        this.parameterMetadata = parameterMetadata;
        this.procedureCall = procedureCall;
    }

    public ProcedureParameterMetadata getParameterMetadata() {
        return this.parameterMetadata;
    }

    public ProcedureCallImpl getProcedureCall() {
        return this.procedureCall;
    }

    @Override
    public boolean isBound(QueryParameterImplementor parameter) {
        return this.getBinding(parameter).isBound();
    }

    @Override
    public ProcedureParameterBindingImplementor<?> getBinding(QueryParameterImplementor parameter) {
        if (!ProcedureParameterImplementor.class.isInstance(parameter)) {
            throw new IllegalArgumentException("Passed parameter is not registered with this query");
        }
        ProcedureParameterImplementor procParam = (ProcedureParameterImplementor)parameter;
        ProcedureParameterBindingImpl binding = this.bindingMap.get(procParam);
        if (binding == null) {
            if (!this.parameterMetadata.containsReference(procParam)) {
                throw new IllegalArgumentException("Passed parameter is not registered with this query");
            }
            binding = new ProcedureParameterBindingImpl(procParam, null);
            this.bindingMap.put(procParam, binding);
        }
        return binding;
    }

    @Override
    public ProcedureParameterBindingImplementor<?> getBinding(String name) {
        return this.getBinding((QueryParameterImplementor)this.parameterMetadata.getQueryParameter(name));
    }

    @Override
    public ProcedureParameterBindingImplementor<?> getBinding(int position) {
        return this.getBinding((QueryParameterImplementor)this.parameterMetadata.getQueryParameter(position));
    }

    @Override
    public void validate() {
        this.parameterMetadata.visitRegistrations(queryParameter -> {
            ProcedureParameterImplementor procParam = (ProcedureParameterImplementor)queryParameter;
            if (procParam.getMode() != ParameterMode.IN && procParam.getMode() != ParameterMode.INOUT || !this.getBinding(procParam).isBound()) {
                // empty if block
            }
        });
    }

    @Override
    public boolean hasAnyMultiValuedBindings() {
        return false;
    }

    @Override
    public void visitBindings(BiConsumer<QueryParameterImplementor<?>, QueryParameterBinding<?>> action) {
        this.parameterMetadata.visitRegistrations(queryParameter -> {
            ProcedureParameterBindingImplementor binding = this.bindingMap.get(queryParameter);
            action.accept((QueryParameterImplementor)queryParameter, binding);
        });
    }
}

