/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.persistence.Parameter;
import org.hibernate.procedure.ParameterStrategyException;
import org.hibernate.procedure.ProcedureParameter;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.spi.ParameterMetadataImplementor;

public class ProcedureParameterMetadata<P extends ProcedureParameterImplementor<?>>
implements ParameterMetadataImplementor<P> {
    private final ProcedureCallImpl procedureCall;
    private ParameterStrategy parameterStrategy = ParameterStrategy.UNKNOWN;
    private List<P> parameters;

    public ProcedureParameterMetadata(ProcedureCallImpl procedureCall) {
        this.procedureCall = procedureCall;
    }

    public ParameterStrategy getParameterStrategy() {
        return this.parameterStrategy;
    }

    public void registerParameter(P parameter) {
        switch (this.parameterStrategy) {
            case UNKNOWN: {
                if (parameter.getName() != null) {
                    this.parameterStrategy = ParameterStrategy.NAMED;
                    break;
                }
                if (parameter.getPosition() != null) {
                    this.parameterStrategy = ParameterStrategy.POSITIONAL;
                    break;
                }
                throw new IllegalArgumentException("Unrecognized parameter type (not named/positional) : " + parameter);
            }
            case NAMED: {
                if (parameter.getName() != null) break;
                throw new ParameterStrategyException("Parameter with no name registered (named parameter mode)");
            }
            case POSITIONAL: {
                if (parameter.getPosition() != null) break;
                throw new ParameterStrategyException("Parameter with no position-label registered (positional parameter mode)");
            }
            default: {
                throw new IllegalStateException("Unaccounted for procedure call parameter strategy : " + (Object)((Object)this.parameterStrategy));
            }
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<P>();
        }
        this.parameters.add(parameter);
    }

    @Override
    public int getParameterCount() {
        return this.parameters.size();
    }

    @Override
    public boolean hasAnyMatching(Predicate<P> filter) {
        for (ProcedureParameterImplementor parameter : this.parameters) {
            if (!filter.test(parameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void collectAllParameters(ParameterMetadataImplementor.ParameterCollector<P> collector) {
        this.parameters.forEach(collector::collect);
    }

    @Override
    public boolean containsReference(P parameter) {
        return this.parameters.contains(parameter);
    }

    @Override
    public void visitRegistrations(Consumer<P> action) {
        for (ProcedureParameterImplementor parameter : this.parameters) {
            action.accept(parameter);
        }
    }

    @Override
    public Set<P> getRegistrations() {
        return new HashSet<P>(this.parameters);
    }

    @Override
    public boolean hasNamedParameters() {
        return this.parameterStrategy == ParameterStrategy.NAMED;
    }

    @Override
    public Set<String> getNamedParameterNames() {
        if (!this.hasNamedParameters()) {
            return Collections.emptySet();
        }
        HashSet<String> rtn = new HashSet<String>();
        for (ProcedureParameter parameter : this.parameters) {
            assert (parameter.getName() != null);
            rtn.add(parameter.getName());
        }
        return rtn;
    }

    @Override
    public boolean hasPositionalParameters() {
        return this.parameterStrategy == ParameterStrategy.POSITIONAL;
    }

    @Override
    public Set<Integer> getOrdinalParameterLabels() {
        if (!this.hasPositionalParameters()) {
            return Collections.emptySet();
        }
        HashSet<Integer> rtn = new HashSet<Integer>();
        for (ProcedureParameter parameter : this.parameters) {
            assert (parameter.getPosition() != null);
            rtn.add(parameter.getPosition());
        }
        return rtn;
    }

    public Set<QueryParameter<?>> collectAllParameters() {
        return new LinkedHashSet(this.parameters);
    }

    @Override
    public P getQueryParameter(String name) {
        assert (name != null);
        if (this.hasNamedParameters()) {
            for (ProcedureParameterImplementor parameter : this.parameters) {
                if (!name.equals(parameter.getName())) continue;
                return (P)parameter;
            }
        }
        throw new IllegalArgumentException("Named parameter [" + name + "] is not registered with this procedure call");
    }

    @Override
    public P getQueryParameter(int positionLabel) {
        if (this.hasPositionalParameters()) {
            for (ProcedureParameterImplementor parameter : this.parameters) {
                if (parameter.getPosition() == null || positionLabel != parameter.getPosition()) continue;
                return (P)parameter;
            }
        }
        throw new IllegalArgumentException("Positional parameter [" + positionLabel + "] is not registered with this procedure call");
    }

    @Override
    public P resolve(Parameter param) {
        if (param instanceof ProcedureParameterImplementor) {
            for (ProcedureParameterImplementor parameter : this.parameters) {
                if (parameter != param) continue;
                return (P)parameter;
            }
        }
        throw new IllegalArgumentException("Could not resolve javax.persistence.Parameter to org.hibernate.query.QueryParameter");
    }
}

