/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import java.util.Objects;
import org.hibernate.DotIdentifierSequence;
import org.hibernate.internal.util.Loggable;
import org.hibernate.internal.util.StringHelper;

public class NavigablePath
implements DotIdentifierSequence,
Loggable {
    public static final String IDENTIFIER_MAPPER_PROPERTY = "_identifierMapper";
    private final NavigablePath parent;
    private final String localName;
    private final String fullPath;
    private final int hashCode;

    public NavigablePath(NavigablePath parent, String navigableName) {
        this.parent = parent;
        this.localName = navigableName;
        if (IDENTIFIER_MAPPER_PROPERTY.equals(navigableName)) {
            this.fullPath = parent != null ? parent.getFullPath() : "";
        } else {
            String resolvedParent;
            String prefix = parent != null ? (StringHelper.isEmpty(resolvedParent = parent.getFullPath()) ? "" : resolvedParent + '.') : "";
            this.fullPath = prefix + navigableName;
        }
        this.hashCode = this.fullPath.hashCode();
    }

    public NavigablePath(String localName) {
        this(null, localName);
    }

    public NavigablePath() {
        this("");
    }

    @Override
    public NavigablePath append(String property) {
        return new NavigablePath(this, property);
    }

    @Override
    public NavigablePath getParent() {
        return this.parent;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.fullPath + ']';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NavigablePath other = (NavigablePath)o;
        return Objects.equals(this.getFullPath(), other.getFullPath());
    }
}

