/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.query.CommonQueryContract;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

@Incubating
public interface Query<R>
extends TypedQuery<R>,
CommonQueryContract {
    public SharedSessionContractImplementor getSession();

    public String getQueryString();

    public Query<R> applyGraph(RootGraph<?> var1, GraphSemantic var2);

    default public Query<R> applyFetchGraph(RootGraph graph) {
        return this.applyGraph(graph, GraphSemantic.FETCH);
    }

    default public Query<R> applyLoadGraph(RootGraph graph) {
        return this.applyGraph(graph, GraphSemantic.LOAD);
    }

    @Deprecated
    default public Iterator<R> iterate() {
        return this.list().iterator();
    }

    public ScrollableResults scroll();

    public ScrollableResults scroll(ScrollMode var1);

    public List<R> list();

    default public List<R> getResultList() {
        return this.list();
    }

    public R uniqueResult();

    default public R getSingleResult() {
        return this.uniqueResult();
    }

    public Optional<R> uniqueResultOptional();

    public Stream<R> stream();

    public String getComment();

    public Query<R> setComment(String var1);

    public Query<R> addQueryHint(String var1);

    public LockOptions getLockOptions();

    public Query<R> setLockOptions(LockOptions var1);

    public Query<R> setLockMode(String var1, LockMode var2);

    public Query<R> setTupleTransformer(TupleTransformer<R> var1);

    public Query<R> setResultListTransformer(ResultListTransformer var1);

    public QueryOptions getQueryOptions();

    public <P extends QueryParameter<?>> ParameterMetadata<P> getParameterMetadata();

    public <T> Query<R> setParameter(QueryParameter<T> var1, T var2);

    @Deprecated
    default public Query<R> setParameter(String name, Object val, Type type) {
        return this.setParameter(name, val, (AllowableParameterType)((Object)type));
    }

    public Query<R> setParameter(String var1, Object var2, AllowableParameterType var3);

    @Deprecated
    default public Query<R> setParameter(int position, Object val, Type type) {
        return this.setParameter(position, val, (AllowableParameterType)((Object)type));
    }

    public Query<R> setParameter(int var1, Object var2, AllowableParameterType var3);

    public <P> Query<R> setParameter(String var1, P var2, TemporalType var3);

    public <P> Query<R> setParameter(int var1, P var2, TemporalType var3);

    public <P> Query<R> setParameter(QueryParameter<P> var1, P var2, TemporalType var3);

    @Deprecated
    default public <P> Query<R> setParameter(QueryParameter<P> parameter, P val, Type type) {
        return this.setParameter(parameter, val, (AllowableParameterType)((Object)type));
    }

    public <P> Query<R> setParameter(QueryParameter<P> var1, P var2, AllowableParameterType var3);

    public Query<R> setParameter(Parameter<Instant> var1, Instant var2, TemporalType var3);

    public Query<R> setParameter(Parameter<LocalDateTime> var1, LocalDateTime var2, TemporalType var3);

    public Query<R> setParameter(Parameter<ZonedDateTime> var1, ZonedDateTime var2, TemporalType var3);

    public Query<R> setParameter(Parameter<OffsetDateTime> var1, OffsetDateTime var2, TemporalType var3);

    public Query<R> setParameter(String var1, Instant var2, TemporalType var3);

    public Query<R> setParameter(String var1, LocalDateTime var2, TemporalType var3);

    public Query<R> setParameter(String var1, ZonedDateTime var2, TemporalType var3);

    public Query<R> setParameter(String var1, OffsetDateTime var2, TemporalType var3);

    public Query<R> setParameter(int var1, Instant var2, TemporalType var3);

    public Query<R> setParameter(int var1, LocalDateTime var2, TemporalType var3);

    public Query<R> setParameter(int var1, ZonedDateTime var2, TemporalType var3);

    public Query<R> setParameter(int var1, OffsetDateTime var2, TemporalType var3);

    @Override
    public Query<R> setHibernateFlushMode(FlushMode var1);

    @Override
    public Query<R> setCacheable(boolean var1);

    @Override
    public Query<R> setCacheRegion(String var1);

    @Override
    public Query<R> setCacheMode(CacheMode var1);

    @Override
    public Query<R> setTimeout(int var1);

    @Override
    public Query<R> setFetchSize(int var1);

    @Override
    public Query<R> setReadOnly(boolean var1);

    public Query<R> setMaxResults(int var1);

    public Query<R> setFirstResult(int var1);

    public Query<R> setHint(String var1, Object var2);

    public Query<R> setFlushMode(FlushModeType var1);

    public Query<R> setLockMode(LockModeType var1);

    public Query<R> setParameter(String var1, Object var2);

    public Query<R> setParameter(int var1, Object var2);

    public <T> Query<R> setParameter(Parameter<T> var1, T var2);

    public Query<R> setParameter(Parameter<Calendar> var1, Calendar var2, TemporalType var3);

    public Query<R> setParameter(Parameter<Date> var1, Date var2, TemporalType var3);

    public Query<R> setParameter(String var1, Calendar var2, TemporalType var3);

    public Query<R> setParameter(String var1, Date var2, TemporalType var3);

    public Query<R> setParameter(int var1, Calendar var2, TemporalType var3);

    public Query<R> setParameter(int var1, Date var2, TemporalType var3);

    public <P> Query<R> setParameterList(QueryParameter<P> var1, Collection<P> var2);

    public Query<R> setParameterList(String var1, Collection var2);

    public Query<R> setParameterList(int var1, Collection var2);

    public Query<R> setParameterList(String var1, Collection var2, Class var3);

    public Query<R> setParameterList(int var1, Collection var2, Class var3);

    @Deprecated
    default public Query<R> setParameterList(String name, Collection values, Type type) {
        return this.setParameter(name, (Object)values, (AllowableParameterType)((Object)type));
    }

    @Deprecated
    default public Query<R> setParameterList(int position, Collection values, Type type) {
        return this.setParameter(position, (Object)values, (AllowableParameterType)((Object)type));
    }

    public Query<R> setParameterList(String var1, Collection var2, AllowableParameterType var3);

    public Query<R> setParameterList(int var1, Collection var2, AllowableParameterType var3);

    @Deprecated
    default public Query<R> setParameterList(String name, Object[] values, Type type) {
        return this.setParameter(name, (Object)values, (AllowableParameterType)((Object)type));
    }

    @Deprecated
    default public Query<R> setParameterList(int position, Object[] values, Type type) {
        return this.setParameter(position, (Object)values, (AllowableParameterType)((Object)type));
    }

    public Query<R> setParameterList(String var1, Object[] var2, AllowableParameterType var3);

    public Query<R> setParameterList(int var1, Object[] var2, AllowableParameterType var3);

    public Query<R> setParameterList(String var1, Object[] var2);

    public Query<R> setParameterList(int var1, Object[] var2);

    public Query<R> setProperties(Object var1);

    public Query<R> setProperties(Map var1);

    @Deprecated
    default public Query<R> setResultTransformer(ResultTransformer transformer) {
        throw new NotYetImplementedException("On 6.0 branch ResultTransformer extends the 2 new contracts");
    }
}

