/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.spi.AbstractJoinOrFetch;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.JoinImplementor;
import org.hibernate.query.criteria.spi.PathSourceImplementor;

public abstract class AbstractJoin<O, T>
extends AbstractJoinOrFetch<O, T>
implements JoinImplementor<O, T> {
    private final JoinType joinType;
    private JpaPredicate suppliedJoinCondition;

    public AbstractJoin(PathSourceImplementor<O> pathSource, PersistentAttributeDescriptor<O, T> joinAttribute, JoinType joinType, CriteriaNodeBuilder criteriaBuilder) {
        super(joinAttribute, pathSource, joinType, criteriaBuilder);
        this.joinType = joinType;
    }

    public PersistentAttributeDescriptor<? super O, T> getNavigable() {
        return (PersistentAttributeDescriptor)super.getNavigable();
    }

    @Override
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public AbstractJoin<O, T> on(Predicate ... restrictions) {
        this.suppliedJoinCondition = null;
        if (restrictions != null && restrictions.length > 0) {
            this.suppliedJoinCondition = this.nodeBuilder().and(restrictions);
        }
        return this;
    }

    @Override
    public AbstractJoin<O, T> on(Expression<Boolean> restriction) {
        this.suppliedJoinCondition = this.nodeBuilder().wrap((Expression)restriction);
        return this;
    }

    @Override
    public Predicate getOn() {
        return this.suppliedJoinCondition;
    }
}

