/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.PathException;
import org.hibernate.query.criteria.spi.AbstractFrom;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.FetchImplementor;
import org.hibernate.query.criteria.spi.JoinImplementor;
import org.hibernate.query.criteria.spi.PathSourceImplementor;

public abstract class AbstractJoinOrFetch<O, T>
extends AbstractFrom<O, T>
implements JoinImplementor<O, T>,
FetchImplementor<O, T> {
    private final JoinType joinType;
    private Predicate suppliedJoinCondition;

    public AbstractJoinOrFetch(PersistentAttributeDescriptor<O, T> navigable, PathSourceImplementor<O> pathSource, JoinType joinType, CriteriaNodeBuilder criteriaBuilder) {
        super(navigable, pathSource, criteriaBuilder);
        this.joinType = joinType;
    }

    @Override
    public PersistentAttributeDescriptor<? super O, ?> getAttribute() {
        return (PersistentAttributeDescriptor)this.getNavigable();
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public Predicate getOn() {
        return this.suppliedJoinCondition;
    }

    protected void verifyRestriction() {
    }

    protected void applyJoinRestriction(JpaExpression<Boolean> restriction) {
        this.verifyRestriction();
        this.suppliedJoinCondition = this.nodeBuilder().wrap(restriction);
    }

    protected void applyJoinRestriction(JpaPredicate ... restrictions) {
        this.verifyRestriction();
        this.suppliedJoinCondition = null;
        if (restrictions != null && restrictions.length > 0) {
            this.suppliedJoinCondition = this.nodeBuilder().and(restrictions);
        }
    }

    @Override
    public <S extends T> AbstractJoinOrFetch<O, S> treatAs(Class<S> treatJavaType) throws PathException {
        return (AbstractJoinOrFetch)super.treatAs((Class)treatJavaType);
    }
}

