/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.List;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaManipulationCriteria;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaSubQuery;
import org.hibernate.query.criteria.spi.AbstractNode;
import org.hibernate.query.criteria.spi.Criteria;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.RootImpl;

public abstract class AbstractManipulationCriteria<T>
extends AbstractNode
implements JpaManipulationCriteria,
Criteria {
    private RootImpl<T> root;
    private JpaPredicate restriction;
    private List<JpaSubQuery<?>> subQueries;

    protected AbstractManipulationCriteria(CriteriaNodeBuilder criteriaBuilder) {
        super(criteriaBuilder);
    }

    public RootImpl from(Class<T> entityClass) {
        EntityDomainType entityType = this.nodeBuilder().getSessionFactory().getMetamodel().entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException(entityClass + " is not an entity");
        }
        return this.from((EntityTypeDescriptor<T>)entityType);
    }

    public RootImpl<T> from(EntityTypeDescriptor<T> entityType) {
        if (this.root != null) {
            // empty if block
        }
        this.root = new RootImpl<T>(entityType, this.nodeBuilder());
        return this.root;
    }

    public RootImpl<T> getRoot() {
        return this.root;
    }

    protected void setRestriction(JpaExpression<Boolean> restriction) {
        this.restriction = this.nodeBuilder().wrap(restriction);
    }

    public void setRestriction(JpaPredicate ... restrictions) {
        this.restriction = this.nodeBuilder().and(restrictions);
    }

    @Override
    public JpaPredicate getRestriction() {
        return this.restriction;
    }

    @Override
    public <U> JpaSubQuery<U> subquery(Class<U> type) {
        throw new NotYetImplementedFor6Exception();
    }

    public void validate() {
        if (this.root == null) {
            throw new IllegalStateException("UPDATE/DELETE criteria must name root entity");
        }
    }
}

