/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import javax.persistence.criteria.Expression;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeBasic;
import org.hibernate.metamodel.model.domain.spi.BagPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.SetPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.criteria.PathException;
import org.hibernate.query.criteria.spi.AbstractExpression;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.ExpressionImplementor;
import org.hibernate.query.criteria.spi.PathImplementor;
import org.hibernate.query.criteria.spi.PathSourceImplementor;
import org.hibernate.query.criteria.spi.PathTypeExpression;
import org.hibernate.query.criteria.spi.PluralPath;
import org.hibernate.query.criteria.spi.SingularPathBasic;
import org.hibernate.query.criteria.spi.SingularPathManaged;
import org.hibernate.query.criteria.spi.TreatedPath;

public abstract class AbstractPath<T>
extends AbstractExpression<T>
implements PathImplementor<T> {
    private final Navigable<T> navigable;
    private final PathSourceImplementor<?> pathSource;
    private final NavigablePath navigablePath;
    private Map<String, PathImplementor<?>> attributePathRegistry;
    private PathTypeExpression<T> pathTypeExpression;

    protected AbstractPath(Navigable<T> navigable, PathSourceImplementor<?> pathSource, CriteriaNodeBuilder criteriaBuilder) {
        super(navigable.getJavaTypeDescriptor(), criteriaBuilder);
        this.navigable = navigable;
        this.pathSource = pathSource;
        this.navigablePath = pathSource == null ? new NavigablePath(navigable.getNavigableRole().getFullPath()) : pathSource.getNavigablePath().append(navigable.getNavigableName());
    }

    @Override
    public Navigable<T> getNavigable() {
        return this.navigable;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public <X> PathSourceImplementor<X> getSource() {
        return this.pathSource;
    }

    public Expression<Class<? extends T>> type() {
        if (this.pathTypeExpression == null) {
            this.pathTypeExpression = new PathTypeExpression(this, this.nodeBuilder());
        }
        return this.pathTypeExpression;
    }

    @Override
    public <Y> PathImplementor<Y> get(String attributeName) {
        return this.resolvePath(attributeName, (pathSource, name) -> {
            PersistentAttribute attribute = pathSource.getManagedType().getAttribute(attributeName);
            if (attribute instanceof SingularPersistentAttribute) {
                return this.createSingularPath((PathSourceImplementor<?>)pathSource, (SingularPersistentAttribute)attribute);
            }
            assert (attribute instanceof PluralPersistentAttribute);
            return this.createPluralPath((PathSourceImplementor<T>)pathSource, (PluralPersistentAttribute)attribute);
        });
    }

    private <Y> PathImplementor<Y> createSingularPath(PathSourceImplementor<?> pathSource, SingularPersistentAttribute<?, Y> attribute) {
        if (attribute instanceof SingularPersistentAttributeBasic) {
            return new SingularPathBasic(pathSource, (SingularPersistentAttributeBasic)attribute, this.nodeBuilder());
        }
        return new SingularPathManaged<Y>(pathSource, attribute, this.nodeBuilder());
    }

    private <E> PluralPath<E> createPluralPath(PathSourceImplementor<T> pathSource, PluralPersistentAttribute<T, ?, E> pluralAttribute) {
        if (pluralAttribute instanceof MapPersistentAttribute) {
            return this.createMapPath(pathSource, (MapPersistentAttribute)pluralAttribute);
        }
        if (pluralAttribute instanceof SetPersistentAttribute) {
            return this.createSetPath(pathSource, (SetPersistentAttribute)pluralAttribute);
        }
        if (pluralAttribute instanceof ListPersistentAttribute) {
            return this.createListPath(pathSource, (ListPersistentAttribute)pluralAttribute);
        }
        if (pluralAttribute instanceof BagPersistentAttribute) {
            return this.getBagPath(pathSource, (BagPersistentAttribute)pluralAttribute);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unexpected PluralPersistentAttribute type [%s] encountered processing path [%s] -> [%s]", pluralAttribute.getClass().getName(), pathSource.getNavigablePath().getFullPath(), pluralAttribute.getAttributeName()));
    }

    private <K, V> PluralPath<V> createMapPath(PathSourceImplementor<T> pathSource, MapPersistentAttribute<T, K, V> attribute) {
        throw new NotYetImplementedFor6Exception();
    }

    private <E> PluralPath<T> createSetPath(PathSourceImplementor<T> pathSource, SetPersistentAttribute<T, E> attribute) {
        throw new NotYetImplementedFor6Exception();
    }

    private <E> PluralPath<E> createListPath(PathSourceImplementor<T> pathSource, ListPersistentAttribute<T, E> attribute) {
        throw new NotYetImplementedFor6Exception();
    }

    private <E> PluralPath<E> getBagPath(PathSourceImplementor<T> pathSource, BagPersistentAttribute<T, E> attribute) {
        throw new NotYetImplementedFor6Exception();
    }

    private <Y> PathImplementor<Y> resolvePath(String attributeName, BiFunction<PathSourceImplementor, String, PathImplementor<Y>> creator) {
        PathSourceImplementor pathSource = this.asPathSource(attributeName);
        if (this.attributePathRegistry == null) {
            this.attributePathRegistry = new HashMap();
            PathImplementor<Y> path = creator.apply(pathSource, attributeName);
            this.attributePathRegistry.put(attributeName, path);
            return path;
        }
        return this.attributePathRegistry.computeIfAbsent(attributeName, name -> (PathImplementor)creator.apply(pathSource, attributeName));
    }

    @Override
    public <Y> PathImplementor<Y> get(SingularAttribute<? super T, Y> jpaAttribute) {
        SingularPersistentAttribute attribute = (SingularPersistentAttribute)jpaAttribute;
        return this.resolvePath(attribute.getName(), (pathSource, name) -> this.createSingularPath((PathSourceImplementor<?>)pathSource, attribute));
    }

    @Override
    public <E, C extends Collection<E>> ExpressionImplementor<C> get(PluralAttribute<T, C, E> attribute) {
        return this.resolvePath(attribute.getName(), (pathSource, name) -> this.createPluralPath((PathSourceImplementor<T>)pathSource, (PluralPersistentAttribute)attribute));
    }

    @Override
    public <K, V, M extends Map<K, V>> ExpressionImplementor<M> get(MapAttribute<T, K, V> map) {
        return this.resolvePath(map.getName(), (pathSource, name) -> this.createMapPath((PathSourceImplementor<T>)pathSource, (MapPersistentAttribute)map));
    }

    @Override
    public <S extends T> PathImplementor<S> treatAs(Class<S> treatJavaType) throws PathException {
        return new TreatedPath(this, this.nodeBuilder().getSessionFactory().getMetamodel().getEntityDescriptor(treatJavaType), this.nodeBuilder());
    }

    protected final PathException illegalDereference(String name) {
        return new PathException(String.format("Illegal attempt to dereference path [%s] as the source for a sub-path [%s]", this.getNavigablePath(), name));
    }

    protected PathException notTreatable() {
        return new PathException(String.format("Illegal attempt to TREAT non-entity path [%s]", this.getNavigablePath()));
    }
}

