/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.criteria.spi.AbstractNode;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.PredicateImplementor;
import org.hibernate.query.criteria.spi.QueryStructure;
import org.hibernate.query.criteria.spi.RootImpl;
import org.hibernate.query.criteria.spi.RootImplementor;
import org.hibernate.query.criteria.spi.SelectCriteriaImplementor;
import org.hibernate.query.criteria.spi.SelectionImplementor;

public abstract class AbstractSelectCriteria<T, C extends SelectCriteriaImplementor<T>>
extends AbstractNode
implements SelectCriteriaImplementor<T> {
    private final QueryStructure<T> queryStructure;
    private final Class<T> resultType;

    public AbstractSelectCriteria(Class<T> resultType, CriteriaNodeBuilder builder) {
        super(builder);
        this.queryStructure = new QueryStructure(builder);
        this.resultType = resultType;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    @Override
    public QueryStructure<T> getQueryStructure() {
        return this.queryStructure;
    }

    public Set<Root<?>> getRoots() {
        return this.queryStructure.getRoots();
    }

    @Override
    public <X> RootImplementor<X> from(Class<X> entityClass) {
        return this.addRoot(new RootImpl(this.nodeBuilder().getSessionFactory().getMetamodel().getEntityDescriptor(entityClass), this.nodeBuilder()));
    }

    private <X> RootImplementor<X> addRoot(RootImpl<X> root) {
        this.queryStructure.addRoot((RootImplementor<?>)root);
        return root;
    }

    @Override
    public <X> RootImplementor<X> from(EntityType<X> entityType) {
        return this.addRoot(new RootImpl((EntityTypeDescriptor)entityType, this.nodeBuilder()));
    }

    public boolean isDistinct() {
        return this.queryStructure.isDistinct();
    }

    public C distinct(boolean distinct) {
        this.queryStructure.setDistinct(distinct);
        return (C)this;
    }

    @Override
    public SelectionImplementor<T> getSelection() {
        return this.queryStructure.getSelection();
    }

    @Override
    public PredicateImplementor getRestriction() {
        return this.queryStructure.getRestriction();
    }

    public C where(Expression<Boolean> restriction) {
        this.queryStructure.setRestriction((Expression)restriction);
        return (C)this;
    }

    public C where(Predicate ... restrictions) {
        this.queryStructure.setRestriction(restrictions);
        return (C)this;
    }

    public List<Expression<?>> getGroupList() {
        return this.queryStructure.getGroupingExpressions();
    }

    public C groupBy(Expression<?> ... expressions) {
        return (C)this.groupBy((List)Arrays.asList(expressions));
    }

    public C groupBy(List<Expression<?>> grouping) {
        ((QueryStructure)this.getQueryStructure()).setGroupingExpressions(grouping);
        return (C)this;
    }

    @Override
    public PredicateImplementor getGroupRestriction() {
        return this.queryStructure.getGroupRestriction();
    }

    public C having(Expression<Boolean> booleanExpression) {
        this.queryStructure.setGroupRestriction(this.nodeBuilder().wrap((Expression)booleanExpression));
        return (C)this;
    }

    public C having(Predicate ... predicates) {
        this.queryStructure.setGroupRestriction(this.nodeBuilder().wrap((Expression[])predicates));
        return (C)this;
    }
}

