/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.spi.AbstractStandardFunction;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;

public abstract class AggregationFunction<T>
extends AbstractStandardFunction<T> {
    private final ExpressionImplementor argument;

    public AggregationFunction(String functionName, Class<T> returnType, Object argument, CriteriaNodeBuilder criteriaBuilder) {
        this(functionName, returnType, (ExpressionImplementor<?>)criteriaBuilder.literal(argument), criteriaBuilder);
    }

    public AggregationFunction(String functionName, Class<T> returnType, ExpressionImplementor<?> argument, CriteriaNodeBuilder criteriaBuilder) {
        super(functionName, returnType, criteriaBuilder);
        this.argument = argument;
    }

    @Override
    public boolean isAggregator() {
        return true;
    }

    public ExpressionImplementor<?> getArgument() {
        return this.argument;
    }

    public static class GREATEST<X extends Comparable<X>>
    extends AggregationFunction<X> {
        public static final String NAME = "max";

        public GREATEST(JpaExpression<X> expression, CriteriaNodeBuilder builder) {
            super(NAME, expression.getJavaType(), expression, builder);
        }

        @Override
        public <R> R accept(CriteriaVisitor visitor) {
            return (R)visitor.visitGreatestFunction(this);
        }
    }

    public static class LEAST<X extends Comparable<X>>
    extends AggregationFunction<X> {
        public static final String NAME = "min";

        public LEAST(JpaExpression<X> expression, CriteriaNodeBuilder criteriaBuilder) {
            super(NAME, expression.getJavaType(), expression, criteriaBuilder);
        }

        @Override
        public <R> R accept(CriteriaVisitor visitor) {
            return (R)visitor.visitLeastFunction(this);
        }
    }

    public static class MIN<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "min";

        public MIN(JpaExpression<N> expression, CriteriaNodeBuilder criteriaBuilder) {
            super(NAME, expression.getJavaType(), expression, criteriaBuilder);
        }

        @Override
        public <R> R accept(CriteriaVisitor visitor) {
            return (R)visitor.visitMinFunction(this);
        }
    }

    public static class MAX<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "max";

        public MAX(JpaExpression<N> expression, CriteriaNodeBuilder criteriaBuilder) {
            super(NAME, expression.getJavaType(), expression, criteriaBuilder);
        }

        @Override
        public <R> R accept(CriteriaVisitor visitor) {
            return (R)visitor.visitMaxFunction(this);
        }
    }

    public static class SUM<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "sum";

        public SUM(JpaExpression<N> expression, CriteriaNodeBuilder criteriaBuilder) {
            super(NAME, expression.getJavaType(), expression, criteriaBuilder);
        }

        public SUM(JpaExpression<? extends Number> expression, Class<N> returnType, CriteriaNodeBuilder criteriaBuilder) {
            super(NAME, returnType, expression, criteriaBuilder);
        }

        @Override
        public <R> R accept(CriteriaVisitor visitor) {
            return (R)visitor.visitSumFunction(this);
        }
    }

    public static class AVG
    extends AggregationFunction<Double> {
        public static final String NAME = "avg";

        public AVG(JpaExpression<? extends Number> expression, CriteriaNodeBuilder criteriaBuilder) {
            super(NAME, Double.class, expression, criteriaBuilder);
        }

        @Override
        public <R> R accept(CriteriaVisitor visitor) {
            return (R)visitor.visitAvgFunction(this);
        }
    }

    public static class COUNT
    extends AggregationFunction<Long> {
        public static final String NAME = "count";
        private final boolean distinct;

        public COUNT(ExpressionImplementor<?> expression, boolean distinct, CriteriaNodeBuilder criteriaBuilder) {
            super(NAME, Long.class, expression, criteriaBuilder);
            this.distinct = distinct;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        @Override
        public <R> R accept(CriteriaVisitor visitor) {
            return (R)visitor.visitCountFunction(this);
        }
    }
}

