/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.criteria.spi.AbstractExpression;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;
import org.hibernate.query.criteria.spi.ImplicitNumericExpressionTypeDeterminer;

public class BinaryArithmetic<N extends Number>
extends AbstractExpression<N> {
    private final ExpressionImplementor<? extends N> lhs;
    private final BinaryArithmeticOperator operator;
    private final ExpressionImplementor<? extends N> rhs;

    public static Class<? extends Number> determineResultType(Class<? extends Number> argument1Type, Class<? extends Number> argument2Type) {
        return BinaryArithmetic.determineResultType(argument1Type, argument2Type, false);
    }

    public static Class<? extends Number> determineResultType(Class<? extends Number> argument1Type, Class<? extends Number> argument2Type, boolean isQuotientOperation) {
        if (isQuotientOperation) {
            return Number.class;
        }
        return ImplicitNumericExpressionTypeDeterminer.determineResultType(argument1Type, argument2Type);
    }

    public BinaryArithmetic(ExpressionImplementor<? extends N> lhs, BinaryArithmeticOperator operator, ExpressionImplementor<? extends N> rhs, Class<N> resultType, CriteriaNodeBuilder criteriaBuilder) {
        super(resultType, criteriaBuilder);
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public BinaryArithmetic(ExpressionImplementor<? extends N> lhs, BinaryArithmeticOperator operator, N rhs, Class<N> javaType, CriteriaNodeBuilder criteriaBuilder) {
        super(javaType, criteriaBuilder);
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = criteriaBuilder.literal(rhs);
    }

    public BinaryArithmetic(N lhs, BinaryArithmeticOperator operator, ExpressionImplementor<? extends N> rhs, Class<N> javaType, CriteriaNodeBuilder criteriaBuilder) {
        super(javaType, criteriaBuilder);
        this.operator = operator;
        this.lhs = criteriaBuilder.literal(lhs);
        this.rhs = rhs;
    }

    public ExpressionImplementor<? extends N> getLeftHandOperand() {
        return this.lhs;
    }

    public BinaryArithmeticOperator getOperator() {
        return this.operator;
    }

    public ExpressionImplementor<? extends N> getRightHandOperand() {
        return this.rhs;
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitBinaryArithmetic(this);
    }
}

