/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.query.criteria.JpaCoalesce;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.spi.AbstractExpression;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class CoalesceExpression<T>
extends AbstractExpression<T>
implements JpaCoalesce<T> {
    private final List<ExpressionImplementor<? extends T>> expressions;

    public CoalesceExpression(CriteriaNodeBuilder builder) {
        super((JavaTypeDescriptor)null, builder);
        this.expressions = new ArrayList<ExpressionImplementor<? extends T>>();
    }

    public CoalesceExpression(List<ExpressionImplementor<T>> expressions, CriteriaNodeBuilder builder) {
        super(expressions.get(0).getJavaTypeDescriptor(), builder);
        this.expressions = new ArrayList<ExpressionImplementor<T>>(expressions);
    }

    public List<ExpressionImplementor<? extends T>> getExpressions() {
        return this.expressions;
    }

    @Override
    public CoalesceExpression<T> value(T value) {
        return this.value((ExpressionImplementor<? extends T>)this.nodeBuilder().literal((Object)value));
    }

    @Override
    public CoalesceExpression<T> value(Expression<? extends T> value) {
        return this.value((ExpressionImplementor)value);
    }

    @Override
    public CoalesceExpression<T> value(ExpressionImplementor<? extends T> value) {
        this.expressions.add(value);
        if (this.getJavaTypeDescriptor() == null) {
            this.setJavaTypeDescriptor(value.getJavaTypeDescriptor());
        }
        return this;
    }

    @Override
    public CoalesceExpression<T> value(JpaExpression<? extends T> value) {
        return this.value((ExpressionImplementor)value);
    }

    @Override
    public CoalesceExpression<T> values(T ... values) {
        return this.values(this.nodeBuilder().literals(values));
    }

    @Override
    public CoalesceExpression<T> values(JpaExpression<? extends T> ... values) {
        return this.values(Arrays.asList(values));
    }

    public CoalesceExpression<T> values(List<ExpressionImplementor<? extends T>> values) {
        this.expressions.addAll(values);
        if (this.getJavaTypeDescriptor() == null) {
            this.setJavaTypeDescriptor(values.get(0).getJavaTypeDescriptor());
        }
        return this;
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitCoalesceExpression(this);
    }
}

