/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.NullPrecedence;
import org.hibernate.SortOrder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.JpaTuple;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.criteria.JpaCriteriaDelete;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaCriteriaUpdate;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaInPredicate;
import org.hibernate.query.criteria.JpaListJoin;
import org.hibernate.query.criteria.JpaMapJoin;
import org.hibernate.query.criteria.JpaParameterExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.JpaSetJoin;
import org.hibernate.query.criteria.spi.AbsFunction;
import org.hibernate.query.criteria.spi.AggregationFunction;
import org.hibernate.query.criteria.spi.BetweenPredicate;
import org.hibernate.query.criteria.spi.BinaryArithmetic;
import org.hibernate.query.criteria.spi.BooleanAssertionPredicate;
import org.hibernate.query.criteria.spi.BooleanExpressionPredicate;
import org.hibernate.query.criteria.spi.CoalesceExpression;
import org.hibernate.query.criteria.spi.CollectionJoinImplementor;
import org.hibernate.query.criteria.spi.ComparisonPredicate;
import org.hibernate.query.criteria.spi.CompoundSelection;
import org.hibernate.query.criteria.spi.ConcatExpression;
import org.hibernate.query.criteria.spi.ConstructorSelection;
import org.hibernate.query.criteria.spi.CriteriaQueryImpl;
import org.hibernate.query.criteria.spi.CurrentDateFunction;
import org.hibernate.query.criteria.spi.CurrentTimeFunction;
import org.hibernate.query.criteria.spi.CurrentTimestampFunction;
import org.hibernate.query.criteria.spi.EmptinessPredicate;
import org.hibernate.query.criteria.spi.ExistsPredicate;
import org.hibernate.query.criteria.spi.ExpressionImplementor;
import org.hibernate.query.criteria.spi.GenericFunction;
import org.hibernate.query.criteria.spi.InPredicate;
import org.hibernate.query.criteria.spi.JoinImplementor;
import org.hibernate.query.criteria.spi.Junction;
import org.hibernate.query.criteria.spi.LengthFunction;
import org.hibernate.query.criteria.spi.LikePredicate;
import org.hibernate.query.criteria.spi.ListJoinImplementor;
import org.hibernate.query.criteria.spi.LiteralExpression;
import org.hibernate.query.criteria.spi.LocateFunction;
import org.hibernate.query.criteria.spi.LowerFunction;
import org.hibernate.query.criteria.spi.MapJoinImplementor;
import org.hibernate.query.criteria.spi.MembershipPredicate;
import org.hibernate.query.criteria.spi.MultiSelectSelection;
import org.hibernate.query.criteria.spi.NullLiteralExpression;
import org.hibernate.query.criteria.spi.NullifExpression;
import org.hibernate.query.criteria.spi.NullnessPredicate;
import org.hibernate.query.criteria.spi.ParameterExpression;
import org.hibernate.query.criteria.spi.PathImplementor;
import org.hibernate.query.criteria.spi.PluralPath;
import org.hibernate.query.criteria.spi.PredicateImplementor;
import org.hibernate.query.criteria.spi.RestrictedSubQueryExpression;
import org.hibernate.query.criteria.spi.RootImplementor;
import org.hibernate.query.criteria.spi.SearchedCase;
import org.hibernate.query.criteria.spi.SelectionImplementor;
import org.hibernate.query.criteria.spi.SetJoinImplementor;
import org.hibernate.query.criteria.spi.SimpleCase;
import org.hibernate.query.criteria.spi.SortSpecification;
import org.hibernate.query.criteria.spi.SqrtFunction;
import org.hibernate.query.criteria.spi.SubQuery;
import org.hibernate.query.criteria.spi.SubstringFunction;
import org.hibernate.query.criteria.spi.TrimFunction;
import org.hibernate.query.criteria.spi.UnaryArithmetic;
import org.hibernate.query.criteria.spi.UpperFunction;
import org.hibernate.query.spi.ComparisonOperator;

public class CriteriaNodeBuilder
implements HibernateCriteriaBuilder {
    private final SessionFactoryImplementor sessionFactory;

    public CriteriaNodeBuilder(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public void close() {
    }

    @Override
    public <X, T> JpaExpression<X> cast(JpaExpression<T> expression, Class<X> castTargetJavaType) {
        throw new NotYetImplementedFor6Exception();
    }

    public PredicateImplementor wrap(ExpressionImplementor<Boolean> expression) {
        if (expression instanceof PredicateImplementor) {
            return (PredicateImplementor)expression;
        }
        if (expression instanceof PathImplementor) {
            return new BooleanAssertionPredicate(expression, Boolean.TRUE, this);
        }
        return new BooleanExpressionPredicate(expression, this);
    }

    @Override
    public PredicateImplementor wrap(Expression<Boolean> expression) {
        return this.wrap((ExpressionImplementor<Boolean>)((ExpressionImplementor)expression));
    }

    @Override
    public PredicateImplementor wrap(Expression<Boolean> ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return null;
        }
        Junction junction = new Junction(Predicate.BooleanOperator.AND, this);
        for (Expression<Boolean> expression : expressions) {
            junction.addExpression((ExpressionImplementor<Boolean>)((Object)this.wrap((Expression)expression)));
        }
        return junction;
    }

    public PredicateImplementor wrap(ExpressionImplementor<Boolean> ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return null;
        }
        Junction junction = new Junction(Predicate.BooleanOperator.AND, this);
        for (ExpressionImplementor<Boolean> expression : expressions) {
            junction.addExpression((ExpressionImplementor<Boolean>)((Object)this.wrap((Expression)expression)));
        }
        return junction;
    }

    @Override
    public JpaCriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(Object.class, this);
    }

    @Override
    public <T> JpaCriteriaQuery<T> createQuery(Class<T> resultClass) {
        return new CriteriaQueryImpl<T>(resultClass, this);
    }

    @Override
    public JpaCriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(Tuple.class, this);
    }

    @Override
    public <T> JpaCriteriaUpdate<T> createCriteriaUpdate(Class<T> targetEntity) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <T> JpaCriteriaDelete<T> createCriteriaDelete(Class<T> targetEntity) {
        throw new NotYetImplementedFor6Exception();
    }

    public <X, T extends X> PathImplementor<T> treat(Path<X> path, Class<T> type) {
        return ((PathImplementor)path).treatAs(type);
    }

    public <X, T extends X> RootImplementor<T> treat(Root<X> root, Class<T> type) {
        return ((RootImplementor)root).treatAs(type);
    }

    public <X, T, V extends T> JoinImplementor<X, V> treat(Join<X, T> join, Class<V> type) {
        return ((JoinImplementor)join).treatAs(type);
    }

    public <X, T, E extends T> CollectionJoinImplementor<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        return ((CollectionJoinImplementor)join).treatAs(type);
    }

    @Override
    public <X, T, E extends T> JpaSetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        return ((SetJoinImplementor)join).treatAs(type);
    }

    @Override
    public <X, T, E extends T> JpaListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        return ((ListJoinImplementor)join).treatAs(type);
    }

    public <X, K, V, S extends V> JpaMapJoin<X, K, S> treat(MapJoin<X, K, V> join, Class<S> type) {
        return ((MapJoinImplementor)join).treatAs((Class)type);
    }

    @Override
    public <Y> JpaCompoundSelection<Y> construct(Class<Y> resultClass, Selection<?>[] selections) {
        return this.construct((Class)resultClass, Arrays.asList(selections));
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> resultClass, List<? extends JpaSelection<?>> selections) {
        return new ConstructorSelection<Y>(resultClass, selections, this);
    }

    public CompoundSelection<Tuple> tuple(Selection<?>[] selections) {
        return this.tuple(Arrays.asList(selections));
    }

    public CompoundSelection<Tuple> tuple(List<? extends JpaSelection<?>> selections) {
        return new MultiSelectSelection<Tuple>((List<SelectionImplementor<?>>)selections, (Class<Tuple>)JpaTuple.class, this);
    }

    public CompoundSelection<Object[]> array(Selection<?>[] selections) {
        return this.array(Arrays.asList(selections));
    }

    public CompoundSelection<Object[]> array(List<? extends JpaSelection<?>> selections) {
        return new MultiSelectSelection<Object[]>((List<SelectionImplementor<?>>)selections, Object[].class, this);
    }

    public <T> ExpressionImplementor<T> literal(T value) {
        return new LiteralExpression<T>(value, this);
    }

    public <T> List<ExpressionImplementor<T>> literals(T[] values) {
        ArrayList<ExpressionImplementor<T>> literals = CollectionHelper.arrayList(values.length);
        for (T value : values) {
            literals.add((ExpressionImplementor<T>)this.literal((Object)value));
        }
        return literals;
    }

    public <T> List<ExpressionImplementor<T>> literals(List<T> values) {
        ArrayList<ExpressionImplementor<T>> literals = CollectionHelper.arrayList(values.size());
        for (T value : values) {
            literals.add((ExpressionImplementor<T>)this.literal((Object)value));
        }
        return literals;
    }

    @Override
    public <T> JpaExpression<T> nullLiteral(Class<T> resultClass) {
        return new NullLiteralExpression<T>(resultClass, this);
    }

    public <N extends Number> AbsFunction<N> abs(Expression<N> argument) {
        return new AbsFunction((ExpressionImplementor)argument, this);
    }

    public <N extends Number> AggregationFunction<Double> avg(Expression<N> argument) {
        return new AggregationFunction.AVG((ExpressionImplementor)argument, this);
    }

    public AggregationFunction<Long> count(Expression<?> argument) {
        return new AggregationFunction.COUNT((ExpressionImplementor)argument, false, this);
    }

    public AggregationFunction<Long> countDistinct(Expression<?> argument) {
        return new AggregationFunction.COUNT((ExpressionImplementor)argument, true, this);
    }

    public <N extends Number> AggregationFunction<N> sum(Expression<N> argument) {
        return new AggregationFunction.SUM((ExpressionImplementor)argument, this);
    }

    public AggregationFunction<Long> sumAsLong(Expression<Integer> argument) {
        return new AggregationFunction.SUM<Long>(((ExpressionImplementor)argument).asLong(), this);
    }

    public AggregationFunction<Double> sumAsDouble(Expression<Float> argument) {
        return new AggregationFunction.SUM<Double>(((ExpressionImplementor)argument).asFloat(), this);
    }

    public <N extends Number> AggregationFunction<N> max(Expression<N> argument) {
        return new AggregationFunction.MAX((ExpressionImplementor)argument, this);
    }

    public <N extends Number> AggregationFunction<N> min(Expression<N> argument) {
        return new AggregationFunction.MIN((ExpressionImplementor)argument, this);
    }

    public <N extends Number> BinaryArithmetic<N> sum(Expression<? extends N> lhs, Expression<? extends N> rhs) {
        if (lhs == null || rhs == null) {
            throw new IllegalArgumentException("arguments to sum() cannot be null");
        }
        Class<Number> resultType = BinaryArithmetic.determineResultType(lhs.getJavaType(), rhs.getJavaType());
        return new BinaryArithmetic<Number>((Number)((Object)((ExpressionImplementor)lhs)), BinaryArithmeticOperator.ADD, (ExpressionImplementor<Number>)((ExpressionImplementor)rhs), resultType, this);
    }

    public <N extends Number> BinaryArithmetic<N> sum(N lhs, Expression<? extends N> rhs) {
        return this.sum((Expression)this.literal(lhs), (Expression)rhs);
    }

    public <N extends Number> BinaryArithmetic<N> sum(Expression<? extends N> lhs, N rhs) {
        return this.sum((Expression)lhs, (Expression)this.literal(rhs));
    }

    public <N extends Number> BinaryArithmetic<N> diff(Expression<? extends N> lhs, Expression<? extends N> rhs) {
        if (lhs == null || rhs == null) {
            throw new IllegalArgumentException("arguments to diff() cannot be null");
        }
        Class<Number> resultType = BinaryArithmetic.determineResultType(lhs.getJavaType(), rhs.getJavaType());
        return new BinaryArithmetic<Number>((Number)((Object)((ExpressionImplementor)lhs)), BinaryArithmeticOperator.SUBTRACT, (ExpressionImplementor<Number>)((ExpressionImplementor)rhs), resultType, this);
    }

    public <N extends Number> BinaryArithmetic<N> diff(Expression<? extends N> lhs, N rhs) {
        return this.diff((Expression)lhs, (Expression)this.literal(rhs));
    }

    public <N extends Number> BinaryArithmetic<N> diff(N lhs, Expression<? extends N> rhs) {
        return this.diff((Expression)this.literal(lhs), (Expression)rhs);
    }

    public <N extends Number> BinaryArithmetic<N> prod(Expression<? extends N> lhs, Expression<? extends N> rhs) {
        if (lhs == null || rhs == null) {
            throw new IllegalArgumentException("arguments to prod() cannot be null");
        }
        Class<Number> resultType = BinaryArithmetic.determineResultType(lhs.getJavaType(), rhs.getJavaType());
        return new BinaryArithmetic<Number>((Number)((Object)((ExpressionImplementor)lhs)), BinaryArithmeticOperator.MULTIPLY, (ExpressionImplementor<Number>)((ExpressionImplementor)rhs), resultType, this);
    }

    public <N extends Number> BinaryArithmetic<N> prod(Expression<? extends N> lhs, N rhs) {
        return this.prod((Expression)lhs, (Expression)this.literal(rhs));
    }

    public <N extends Number> BinaryArithmetic<N> prod(N lhs, Expression<? extends N> rhs) {
        return this.prod((Expression)this.literal(lhs), (Expression)rhs);
    }

    public BinaryArithmetic<Number> quot(Expression<? extends Number> lhs, Expression<? extends Number> rhs) {
        if (lhs == null || rhs == null) {
            throw new IllegalArgumentException("arguments to quot() cannot be null");
        }
        Class<Number> resultType = BinaryArithmetic.determineResultType(lhs.getJavaType(), rhs.getJavaType());
        return new BinaryArithmetic<Number>((Number)((Object)((ExpressionImplementor)lhs)), BinaryArithmeticOperator.DIVIDE, (ExpressionImplementor<Number>)((ExpressionImplementor)rhs), resultType, this);
    }

    public BinaryArithmetic<Number> quot(Expression<? extends Number> lhs, Number rhs) {
        return this.quot((Expression)lhs, (Expression)this.literal(rhs));
    }

    public BinaryArithmetic<Number> quot(Number lhs, Expression<? extends Number> rhs) {
        return this.quot((Expression)this.literal(lhs), (Expression)rhs);
    }

    public BinaryArithmetic<Integer> mod(Expression<Integer> lhs, Expression<Integer> rhs) {
        if (lhs == null || rhs == null) {
            throw new IllegalArgumentException("arguments to quot() cannot be null");
        }
        Class<Number> resultType = BinaryArithmetic.determineResultType(lhs.getJavaType(), rhs.getJavaType());
        return new BinaryArithmetic<Number>((Number)((Object)((ExpressionImplementor)lhs)), BinaryArithmeticOperator.DIVIDE, (ExpressionImplementor<Number>)((ExpressionImplementor)rhs), resultType, this);
    }

    @Override
    public JpaExpression<Integer> mod(Expression<Integer> lhs, Integer rhs) {
        return this.mod((Expression)lhs, (Expression)this.literal(rhs));
    }

    @Override
    public JpaExpression<Integer> mod(Integer lhs, Expression<Integer> rhs) {
        return this.mod((Expression)this.literal(lhs), (Expression)rhs);
    }

    public SqrtFunction sqrt(Expression<? extends Number> argument) {
        return new SqrtFunction((ExpressionImplementor)argument, this);
    }

    public <N extends Number> UnaryArithmetic<N> neg(Expression<N> operand) {
        return new UnaryArithmetic(UnaryArithmeticOperator.UNARY_MINUS, (ExpressionImplementor)operand, this);
    }

    @Override
    public <T> CoalesceExpression<T> coalesce() {
        return new CoalesceExpression(this);
    }

    public <Y> CoalesceExpression<Y> coalesce(Expression<? extends Y> x, Expression<? extends Y> y) {
        return this.coalesce((ExpressionImplementor)x, (ExpressionImplementor)y);
    }

    public <Y> CoalesceExpression<Y> coalesce(ExpressionImplementor<? extends Y> x, ExpressionImplementor<? extends Y> y) {
        return new CoalesceExpression(Arrays.asList(x, y), this);
    }

    public <Y> CoalesceExpression<Y> coalesce(Expression<? extends Y> x, Y y) {
        return this.coalesce((Expression)x, this.literal(y));
    }

    public ConcatExpression concat(Expression<String> first, Expression<String> second) {
        return this.concat((ExpressionImplementor)first, (ExpressionImplementor)second);
    }

    public ConcatExpression concat(ExpressionImplementor<String> first, ExpressionImplementor<String> second) {
        return new ConcatExpression(first, second, this);
    }

    public ConcatExpression concat(Expression<String> first, String second) {
        return this.concat((Expression)first, (Expression)this.literal(second));
    }

    public ConcatExpression concat(String first, Expression<String> second) {
        return this.concat((Expression)this.literal(first), (Expression)second);
    }

    public ConcatExpression concat(String first, String second) {
        return this.concat((ExpressionImplementor<String>)this.literal(first), (ExpressionImplementor<String>)this.literal(second));
    }

    public <Y> RestrictedSubQueryExpression<Y> all(Subquery<Y> subquery) {
        return new RestrictedSubQueryExpression((SubQuery)subquery, RestrictedSubQueryExpression.Modifier.ALL, this);
    }

    public <Y> RestrictedSubQueryExpression<Y> some(Subquery<Y> subquery) {
        return new RestrictedSubQueryExpression((SubQuery)subquery, RestrictedSubQueryExpression.Modifier.SOME, this);
    }

    public <Y> RestrictedSubQueryExpression<Y> any(Subquery<Y> subquery) {
        return new RestrictedSubQueryExpression((SubQuery)subquery, RestrictedSubQueryExpression.Modifier.ANY, this);
    }

    public <C, R> SimpleCase<C, R> selectCase(Expression<? extends C> expression) {
        return this.selectCase((ExpressionImplementor)expression);
    }

    public <C, R> SimpleCase<C, R> selectCase(ExpressionImplementor<? extends C> expression) {
        return new SimpleCase(expression, this);
    }

    @Override
    public <R> SearchedCase<R> selectCase() {
        return new SearchedCase(this);
    }

    public <Y> NullifExpression<Y> nullif(Expression<Y> primary, Expression<?> secondary) {
        return new NullifExpression((ExpressionImplementor)primary, (ExpressionImplementor)secondary, this);
    }

    public <Y> NullifExpression<Y> nullif(Expression<Y> primary, Y secondary) {
        return this.nullif((Expression)primary, this.literal(secondary));
    }

    @Override
    public JpaExpression<Long> toLong(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asLong();
    }

    @Override
    public JpaExpression<Integer> toInteger(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asInteger();
    }

    @Override
    public JpaExpression<Float> toFloat(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asFloat();
    }

    @Override
    public JpaExpression<Double> toDouble(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asDouble();
    }

    @Override
    public JpaExpression<BigDecimal> toBigDecimal(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asBigDecimal();
    }

    @Override
    public JpaExpression<BigInteger> toBigInteger(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asBigInteger();
    }

    @Override
    public JpaExpression<String> toString(Expression<Character> expression) {
        return ((ExpressionImplementor)expression).asString();
    }

    @Override
    public <T> JpaParameterExpression<T> parameter(Class<T> paramClass) {
        return new ParameterExpression<T>(paramClass, this);
    }

    @Override
    public <T> JpaParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpression<T>(name, paramClass, this);
    }

    public <T> GenericFunction<T> function(String name, Class<T> type, Expression<?>[] args) {
        return this.function(name, type, Arrays.asList(args));
    }

    public <T> GenericFunction<T> function(String name, Class<T> type, List<ExpressionImplementor<?>> args) {
        return new GenericFunction<T>(name, args, type, this);
    }

    @Override
    public CurrentDateFunction currentDate() {
        return new CurrentDateFunction(this);
    }

    @Override
    public CurrentTimestampFunction currentTimestamp() {
        return new CurrentTimestampFunction(this);
    }

    @Override
    public CurrentTimeFunction currentTime() {
        return new CurrentTimeFunction(this);
    }

    public LowerFunction lower(Expression<String> stringExpression) {
        return this.lower((ExpressionImplementor)stringExpression);
    }

    public LowerFunction lower(ExpressionImplementor<String> stringExpression) {
        return new LowerFunction(stringExpression, this);
    }

    public UpperFunction upper(Expression<String> stringExpression) {
        return this.upper((ExpressionImplementor)stringExpression);
    }

    public UpperFunction upper(ExpressionImplementor<String> stringExpression) {
        return new UpperFunction(stringExpression, this);
    }

    public LengthFunction length(Expression<String> stringExpression) {
        return this.length((ExpressionImplementor)stringExpression);
    }

    public LengthFunction length(ExpressionImplementor<String> stringExpression) {
        return new LengthFunction(stringExpression, this);
    }

    public LocateFunction locate(Expression<String> expression, String pattern) {
        return this.locate((Expression)expression, this.literal(pattern));
    }

    public LocateFunction locate(Expression<String> expression, Expression<String> pattern) {
        return this.locate((Expression)expression, (Expression)pattern, (Expression)null);
    }

    public LocateFunction locate(Expression<String> expression, Expression<String> pattern, Expression<Integer> from) {
        return this.locate((ExpressionImplementor)expression, (ExpressionImplementor)pattern, (ExpressionImplementor)from);
    }

    public LocateFunction locate(ExpressionImplementor<String> expression, ExpressionImplementor<String> pattern, ExpressionImplementor<Integer> from) {
        return new LocateFunction(expression, pattern, from, this);
    }

    public LocateFunction locate(Expression<String> expression, String pattern, int from) {
        return this.locate((Expression)expression, this.literal(pattern), this.literal((Object)from));
    }

    public SubstringFunction substring(Expression<String> value, int start) {
        return this.substring((Expression)value, this.literal((Object)start));
    }

    public SubstringFunction substring(Expression<String> value, Expression<Integer> start) {
        return this.substring((Expression)value, (Expression)start, (Expression)null);
    }

    public SubstringFunction substring(Expression<String> value, Expression<Integer> start, Expression<Integer> length) {
        return this.substring((ExpressionImplementor)value, (ExpressionImplementor)start, (ExpressionImplementor)length);
    }

    public SubstringFunction substring(ExpressionImplementor<String> value, ExpressionImplementor<Integer> start, ExpressionImplementor<Integer> length) {
        return new SubstringFunction(value, start, length, this);
    }

    public SubstringFunction substring(Expression<String> value, int start, int length) {
        return this.substring((Expression)value, this.literal((Object)start), this.literal((Object)length));
    }

    public TrimFunction trim(Expression<String> value) {
        return this.trim(CriteriaBuilder.Trimspec.BOTH, (Expression)value);
    }

    public TrimFunction trim(CriteriaBuilder.Trimspec trimspec, Expression<String> value) {
        return this.trim(trimspec, this.literal(Character.valueOf(' ')), (Expression)value);
    }

    public TrimFunction trim(Expression<Character> trimCharacter, Expression<String> value) {
        return this.trim(CriteriaBuilder.Trimspec.BOTH, (Expression)trimCharacter, (Expression)value);
    }

    public TrimFunction trim(CriteriaBuilder.Trimspec trimspec, Expression<Character> trimCharacter, Expression<String> value) {
        return this.trim(trimspec, (ExpressionImplementor)trimCharacter, (ExpressionImplementor)value);
    }

    public TrimFunction trim(CriteriaBuilder.Trimspec trimspec, ExpressionImplementor<Character> trimCharacter, ExpressionImplementor<String> value) {
        return new TrimFunction(trimspec, trimCharacter, value, this);
    }

    public TrimFunction trim(char trimCharacter, Expression<String> value) {
        return this.trim(this.literal(Character.valueOf(trimCharacter)), (Expression)value);
    }

    public TrimFunction trim(CriteriaBuilder.Trimspec trimspec, char trimCharacter, Expression<String> value) {
        return this.trim(trimspec, this.literal(Character.valueOf(trimCharacter)), (Expression)value);
    }

    @Override
    public PredicateImplementor not(Expression<Boolean> restriction) {
        return this.wrap((Expression)restriction).not();
    }

    @Override
    public PredicateImplementor and(Expression<Boolean> x, Expression<Boolean> y) {
        return new Junction(Predicate.BooleanOperator.AND, Arrays.asList(x, y), this);
    }

    @Override
    public PredicateImplementor and(Predicate ... restrictions) {
        return new Junction(Predicate.BooleanOperator.AND, Arrays.asList(restrictions), this);
    }

    @Override
    public PredicateImplementor or(Expression<Boolean> x, Expression<Boolean> y) {
        return new Junction(Predicate.BooleanOperator.OR, Arrays.asList(x, y), this);
    }

    @Override
    public PredicateImplementor or(Predicate ... restrictions) {
        return new Junction(Predicate.BooleanOperator.OR, Arrays.asList(restrictions), this);
    }

    @Override
    public PredicateImplementor conjunction() {
        return new Junction(Predicate.BooleanOperator.AND, this);
    }

    @Override
    public PredicateImplementor disjunction() {
        return new Junction(Predicate.BooleanOperator.OR, this);
    }

    @Override
    public PredicateImplementor isTrue(Expression<Boolean> x) {
        return new BooleanAssertionPredicate((ExpressionImplementor)x, true, this);
    }

    @Override
    public PredicateImplementor isFalse(Expression<Boolean> x) {
        return new BooleanAssertionPredicate((ExpressionImplementor)x, false, this);
    }

    @Override
    public PredicateImplementor isNull(Expression<?> x) {
        return new NullnessPredicate((ExpressionImplementor)x, this);
    }

    @Override
    public PredicateImplementor isNotNull(Expression<?> x) {
        return this.isNull((Expression)x).not();
    }

    @Override
    public PredicateImplementor equal(Expression<?> x, Expression<?> y) {
        return new ComparisonPredicate((ExpressionImplementor)x, ComparisonOperator.EQUAL, (ExpressionImplementor)y, this);
    }

    @Override
    public PredicateImplementor equal(Expression<?> x, Object y) {
        return this.equal((Expression)x, this.literal(y));
    }

    @Override
    public PredicateImplementor notEqual(Expression<?> x, Expression<?> y) {
        return new ComparisonPredicate((ExpressionImplementor)x, ComparisonOperator.NOT_EQUAL, (ExpressionImplementor)y, this);
    }

    @Override
    public PredicateImplementor notEqual(Expression<?> x, Object y) {
        return this.notEqual((Expression)x, this.literal(y));
    }

    @Override
    public <Y extends Comparable<? super Y>> PredicateImplementor greaterThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate((ExpressionImplementor)x, ComparisonOperator.GREATER_THAN, (ExpressionImplementor)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> PredicateImplementor greaterThan(Expression<? extends Y> x, Y y) {
        return this.greaterThan((Expression)x, this.literal(y));
    }

    @Override
    public <Y extends Comparable<? super Y>> PredicateImplementor greaterThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate((ExpressionImplementor)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, (ExpressionImplementor)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> PredicateImplementor greaterThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return this.greaterThanOrEqualTo((Expression)x, this.literal(y));
    }

    @Override
    public <Y extends Comparable<? super Y>> PredicateImplementor lessThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate((ExpressionImplementor)x, ComparisonOperator.LESS_THAN, (ExpressionImplementor)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> PredicateImplementor lessThan(Expression<? extends Y> x, Y y) {
        return this.lessThan((Expression)x, this.literal(y));
    }

    @Override
    public <Y extends Comparable<? super Y>> PredicateImplementor lessThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate((ExpressionImplementor)x, ComparisonOperator.LESS_THAN_OR_EQUAL, (ExpressionImplementor)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> PredicateImplementor lessThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return this.lessThanOrEqualTo((Expression)x, this.literal(y));
    }

    @Override
    public PredicateImplementor gt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate((ExpressionImplementor)x, ComparisonOperator.GREATER_THAN, (ExpressionImplementor)y, this);
    }

    @Override
    public PredicateImplementor gt(Expression<? extends Number> x, Number y) {
        return this.gt((Expression)x, this.literal(y));
    }

    @Override
    public PredicateImplementor ge(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate((ExpressionImplementor)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, (ExpressionImplementor)y, this);
    }

    @Override
    public PredicateImplementor ge(Expression<? extends Number> x, Number y) {
        return this.ge((Expression)x, this.literal(y));
    }

    @Override
    public PredicateImplementor lt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate((ExpressionImplementor)x, ComparisonOperator.LESS_THAN, (ExpressionImplementor)y, this);
    }

    @Override
    public PredicateImplementor lt(Expression<? extends Number> x, Number y) {
        return this.lt((Expression)x, this.literal(y));
    }

    @Override
    public PredicateImplementor le(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate((ExpressionImplementor)x, ComparisonOperator.LESS_THAN_OR_EQUAL, (ExpressionImplementor)y, this);
    }

    @Override
    public PredicateImplementor le(Expression<? extends Number> x, Number y) {
        return this.le((Expression)x, this.literal(y));
    }

    @Override
    public <Y extends Comparable<? super Y>> PredicateImplementor between(Expression<? extends Y> value, Expression<? extends Y> lower, Expression<? extends Y> upper) {
        return new BetweenPredicate((ExpressionImplementor)value, (ExpressionImplementor)lower, (ExpressionImplementor)upper, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> PredicateImplementor between(Expression<? extends Y> value, Y lower, Y upper) {
        return this.between((Expression)value, this.literal(upper), this.literal(lower));
    }

    @Override
    public PredicateImplementor like(Expression<String> expression, String pattern) {
        return this.like((Expression)expression, this.literal(pattern));
    }

    @Override
    public PredicateImplementor like(Expression<String> expression, Expression<String> pattern) {
        return this.like((Expression)expression, (Expression)pattern, (Expression)null);
    }

    @Override
    public PredicateImplementor like(Expression<String> expression, Expression<String> pattern, Expression<Character> escapeChar) {
        return new LikePredicate((ExpressionImplementor)expression, (ExpressionImplementor)pattern, (ExpressionImplementor)escapeChar, this);
    }

    @Override
    public PredicateImplementor like(Expression<String> expression, Expression<String> pattern, char escapeChar) {
        return this.like((Expression)expression, (Expression)pattern, (Expression)this.literal(Character.valueOf(escapeChar)));
    }

    @Override
    public PredicateImplementor like(Expression<String> expression, String pattern, Expression<Character> escapeChar) {
        return this.like((Expression)expression, (Expression)this.literal(pattern), (Expression)escapeChar);
    }

    @Override
    public PredicateImplementor like(Expression<String> expression, String pattern, char escapeChar) {
        return this.like((Expression)expression, (Expression)this.literal(pattern), (Expression)this.literal(Character.valueOf(escapeChar)));
    }

    @Override
    public PredicateImplementor notLike(Expression<String> expression, String pattern) {
        return this.notLike((Expression)expression, this.literal(pattern));
    }

    @Override
    public PredicateImplementor notLike(Expression<String> expression, Expression<String> pattern) {
        return this.notLike((Expression)expression, (Expression)pattern, (Expression)null);
    }

    @Override
    public PredicateImplementor notLike(Expression<String> expression, Expression<String> pattern, Expression<Character> escapeChar) {
        return new LikePredicate((ExpressionImplementor)expression, (ExpressionImplementor)pattern, (ExpressionImplementor)escapeChar, true, this);
    }

    @Override
    public PredicateImplementor notLike(Expression<String> expression, Expression<String> pattern, char escapeChar) {
        return this.notLike((Expression)expression, (Expression)pattern, (Expression)this.literal(Character.valueOf(escapeChar)));
    }

    @Override
    public PredicateImplementor notLike(Expression<String> expression, String pattern, Expression<Character> escapeChar) {
        return this.notLike((Expression)expression, (Expression)this.literal(pattern), (Expression)escapeChar);
    }

    @Override
    public PredicateImplementor notLike(Expression<String> expression, String pattern, char escapeChar) {
        return this.notLike((Expression)expression, (Expression)this.literal(pattern), (Expression)this.literal(Character.valueOf(escapeChar)));
    }

    @Override
    public <T> JpaInPredicate<T> in(Expression<? extends T> expression) {
        return new InPredicate((ExpressionImplementor)expression, this);
    }

    @Override
    public <T> JpaInPredicate<T> in(Expression<? extends T> expression, Expression<? extends T> ... values) {
        return new InPredicate<T>((ExpressionImplementor)expression, Arrays.asList(values), this);
    }

    @Override
    public <T> JpaInPredicate<T> in(Expression<? extends T> expression, T ... values) {
        return new InPredicate((ExpressionImplementor)expression, this.literals(values), this);
    }

    @Override
    public <T> JpaInPredicate<T> in(Expression<? extends T> expression, List<T> values) {
        return new InPredicate((ExpressionImplementor)expression, this.literals(values), this);
    }

    @Override
    public ExistsPredicate exists(Subquery<?> subquery) {
        return new ExistsPredicate((SubQuery)subquery, this);
    }

    @Override
    public <C extends Collection<?>> EmptinessPredicate isEmpty(Expression<C> pluralPathExpression) {
        if (pluralPathExpression instanceof PluralPath) {
            return new EmptinessPredicate((PluralPath)pluralPathExpression, this);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown collection expression type [%s] for is_empty check", pluralPathExpression.getClass().getName()));
    }

    @Override
    public <C extends Collection<?>> EmptinessPredicate isNotEmpty(Expression<C> pluralPathExpression) {
        if (pluralPathExpression instanceof PluralPath) {
            return new EmptinessPredicate((PluralPath)pluralPathExpression, true, this);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown collection expression type [%s] for is_not_empty check", pluralPathExpression.getClass().getName()));
    }

    @Override
    public <M extends Map<?, ?>> EmptinessPredicate isMapEmpty(JpaExpression<M> pluralPathExpression) {
        if (pluralPathExpression instanceof PluralPath) {
            return new EmptinessPredicate((PluralPath)pluralPathExpression, this);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown map expression type [%s] for is_empty check", pluralPathExpression.getClass().getName()));
    }

    @Override
    public <M extends Map<?, ?>> JpaPredicate isMapNotEmpty(JpaExpression<M> pluralPathExpression) {
        if (pluralPathExpression instanceof PluralPath) {
            return new EmptinessPredicate((PluralPath)pluralPathExpression, true, this);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown map expression type [%s] for is_not_empty check", pluralPathExpression.getClass().getName()));
    }

    @Override
    public <E, C extends Collection<E>> JpaPredicate isMember(Expression<E> elem, Expression<C> pluralPathExpression) {
        if (pluralPathExpression instanceof PluralPath) {
            return new MembershipPredicate((ExpressionImplementor)elem, (PluralPath)pluralPathExpression, this);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown map expression type [%s] for is_member check", pluralPathExpression.getClass().getName()));
    }

    @Override
    public <E, C extends Collection<E>> JpaPredicate isMember(E elem, Expression<C> pluralPathExpression) {
        return this.isMember(this.literal(elem), (Expression)pluralPathExpression);
    }

    @Override
    public <E, C extends Collection<E>> JpaPredicate isNotMember(Expression<E> elem, Expression<C> pluralPathExpression) {
        if (pluralPathExpression instanceof PluralPath) {
            return new MembershipPredicate((ExpressionImplementor)elem, (PluralPath)pluralPathExpression, true, this);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown map expression type [%s] for is_member check", pluralPathExpression.getClass().getName()));
    }

    @Override
    public <E, C extends Collection<E>> JpaPredicate isNotMember(E elem, Expression<C> pluralPathExpression) {
        return this.isNotMember(this.literal(elem), (Expression)pluralPathExpression);
    }

    @Override
    public SortSpecification sort(JpaExpression<?> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return new SortSpecification((ExpressionImplementor)sortExpression, sortOrder, nullPrecedence, this);
    }

    @Override
    public SortSpecification sort(JpaExpression<?> sortExpression, SortOrder sortOrder) {
        return this.sort((JpaExpression)sortExpression, sortOrder, NullPrecedence.NONE);
    }

    @Override
    public SortSpecification sort(JpaExpression<?> sortExpression) {
        return this.sort((JpaExpression)sortExpression, SortOrder.ASCENDING);
    }

    @Override
    public SortSpecification asc(Expression<?> sortExpression) {
        return this.sort((JpaExpression)((ExpressionImplementor)sortExpression), SortOrder.ASCENDING);
    }

    @Override
    public SortSpecification desc(Expression<?> sortExpression) {
        return this.sort((JpaExpression)((ExpressionImplementor)sortExpression), SortOrder.DESCENDING);
    }

    public <X extends Comparable<? super X>> ExpressionImplementor<X> greatest(Expression<X> argument) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <X extends Comparable<? super X>> JpaExpression<X> least(Expression<X> argument) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <K, M extends Map<K, ?>> JpaExpression<Set<K>> keys(M map) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <K, L extends List<?>> JpaExpression<Set<K>> indexes(L list) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <V, C extends Collection<V>> JpaExpression<Collection<V>> values(C collection) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M map) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <C extends Collection<?>> JpaExpression<Integer> size(Expression<C> collection) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <C extends Collection<?>> JpaExpression<Integer> size(C collection) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <M extends Map<?, ?>> JpaExpression<Integer> mapSize(JpaExpression<M> mapExpression) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <M extends Map<?, ?>> JpaExpression<Integer> mapSize(M map) {
        throw new NotYetImplementedFor6Exception();
    }
}

