/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Selection;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.query.JpaTuple;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.criteria.spi.AbstractSelectCriteria;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ParameterCollector;
import org.hibernate.query.criteria.spi.QueryStructure;
import org.hibernate.query.criteria.spi.RootQuery;
import org.hibernate.query.criteria.spi.SelectionImplementor;
import org.hibernate.query.criteria.spi.SubQuery;

public class CriteriaQueryImpl<T>
extends AbstractSelectCriteria<T, RootQuery<T>>
implements RootQuery<T> {
    public CriteriaQueryImpl(Class<T> resultType, CriteriaNodeBuilder criteriaBuilder) {
        super(resultType, criteriaBuilder);
    }

    @Override
    public RootQuery<T> select(Selection<? extends T> selection) {
        ((QueryStructure)this.getQueryStructure()).setSelection((SelectionImplementor)selection);
        return this;
    }

    @Override
    public RootQuery<T> multiselect(Selection<?> ... selections) {
        this.applyMultiSelect(Arrays.asList(selections));
        return this;
    }

    private void applyMultiSelect(List<? extends SelectionImplementor<?>> selections) {
        JpaCompoundSelection selection;
        if (JpaTuple.class.isAssignableFrom(this.getResultType())) {
            selection = this.nodeBuilder().tuple(selections);
        } else if (this.getResultType().isArray()) {
            selection = this.nodeBuilder().array(selections);
        } else if (Object.class.equals(this.getResultType())) {
            switch (selections.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty selections passed to criteria query typed as Object");
                }
                case 1: {
                    selection = selections.get(0);
                    break;
                }
                default: {
                    selection = this.nodeBuilder().array(selections);
                    break;
                }
            }
        } else {
            selection = this.nodeBuilder().construct(this.getResultType(), selections);
        }
        this.select(selection);
    }

    @Override
    public RootQuery<T> multiselect(List<Selection<?>> selections) {
        this.applyMultiSelect(selections);
        return this;
    }

    @Override
    public RootQuery<T> orderBy(Order ... o) {
        return this.orderBy((List)Arrays.asList(o));
    }

    @Override
    public RootQuery<T> orderBy(List<Order> orderList) {
        ((QueryStructure)this.getQueryStructure()).setSortSpecifications(orderList);
        return this;
    }

    public <U> SubQuery<U> subquery(Class<U> type) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        return ParameterCollector.collectParameters(this);
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitRootQuery(this);
    }
}

