/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaInPredicate;
import org.hibernate.query.criteria.spi.AbstractSimplePredicate;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;

public class InPredicate<T>
extends AbstractSimplePredicate
implements JpaInPredicate<T> {
    private final ExpressionImplementor<? extends T> expression;
    private final List<ExpressionImplementor<? extends T>> values;

    public InPredicate(ExpressionImplementor<? extends T> expression, CriteriaNodeBuilder nodeBuilder) {
        this(expression, null, nodeBuilder);
    }

    public InPredicate(ExpressionImplementor<? extends T> expression, List<ExpressionImplementor<? extends T>> values, CriteriaNodeBuilder nodeBuilder) {
        super(nodeBuilder);
        if (values == null) {
            values = new ArrayList<ExpressionImplementor<? extends T>>();
        }
        this.expression = expression;
        this.values = values;
    }

    @Override
    public ExpressionImplementor<T> getExpression() {
        return this.expression;
    }

    public List<ExpressionImplementor<? extends T>> getValues() {
        return this.values;
    }

    @Override
    public InPredicate<T> value(T value) {
        return this.value((ExpressionImplementor<? extends T>)this.nodeBuilder().literal((Object)value));
    }

    @Override
    public InPredicate<T> value(JpaExpression<? extends T> value) {
        return this.value((ExpressionImplementor)value);
    }

    @Override
    public InPredicate<T> value(Expression<? extends T> value) {
        return this.value((ExpressionImplementor)value);
    }

    @Override
    public InPredicate<T> value(ExpressionImplementor<? extends T> value) {
        this.values.add(value);
        return this;
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitInPredicate(this);
    }
}

