/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.hibernate.query.criteria.spi.AbstractPredicate;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;

public class Junction
extends AbstractPredicate {
    private final Predicate.BooleanOperator operator;
    private List<ExpressionImplementor<Boolean>> expressions;

    protected Junction(Predicate.BooleanOperator operator, CriteriaNodeBuilder criteriaBuilder) {
        super(criteriaBuilder);
        this.operator = operator;
    }

    protected Junction(Predicate.BooleanOperator operator, List<ExpressionImplementor<Boolean>> expressions, CriteriaNodeBuilder criteriaBuilder) {
        super(criteriaBuilder);
        this.operator = operator;
        this.expressions = expressions;
    }

    public Predicate.BooleanOperator getOperator() {
        return this.operator;
    }

    public List<Expression<Boolean>> getExpressions() {
        return this.expressions == null ? Collections.emptyList() : this.expressions;
    }

    public Junction visitExpressions(Consumer<ExpressionImplementor> consumer) {
        if (this.expressions != null) {
            this.expressions.forEach(consumer);
        }
        return this;
    }

    public Junction addExpression(ExpressionImplementor<Boolean> expression) {
        if (this.expressions == null) {
            this.expressions = new ArrayList<ExpressionImplementor<Boolean>>();
        }
        this.expressions.add(expression);
        return this;
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitJunctionPredicate(this);
    }
}

