/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.io.Serializable;
import org.hibernate.query.criteria.spi.AbstractExpression;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class LiteralExpression<T>
extends AbstractExpression<T>
implements Serializable {
    private Object value;

    public LiteralExpression(T value, CriteriaNodeBuilder builder) {
        this(LiteralExpression.determineClass(value), value, builder);
    }

    private static Class determineClass(Object literal) {
        return literal == null ? null : literal.getClass();
    }

    public LiteralExpression(Class<T> type, T value, CriteriaNodeBuilder builder) {
        super(type, builder);
        this.value = value;
    }

    public T getValue() {
        return (T)this.value;
    }

    @Override
    protected void setJavaType(Class targetType) {
        JavaTypeDescriptor<Object> jtd = this.getJavaTypeDescriptor();
        super.setJavaType(targetType);
        this.value = jtd.unwrap(this.value, targetType, null);
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitLiteral(this);
    }
}

