/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.hibernate.query.criteria.spi.AbstractPredicate;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;
import org.hibernate.query.criteria.spi.Junction;
import org.hibernate.query.criteria.spi.PredicateImplementor;

public class NegatedPredicateWrapper
extends AbstractPredicate {
    private final PredicateImplementor wrappedPredicate;
    private final Predicate.BooleanOperator negatedOperator;
    private final List<ExpressionImplementor<Boolean>> negatedExpressions;

    public NegatedPredicateWrapper(PredicateImplementor wrappedPredicate) {
        super(wrappedPredicate.nodeBuilder());
        this.wrappedPredicate = wrappedPredicate;
        this.negatedOperator = wrappedPredicate instanceof Junction ? PredicateImplementor.reverseOperator(wrappedPredicate.getOperator()) : wrappedPredicate.getOperator();
        this.negatedExpressions = NegatedPredicateWrapper.negateCompoundExpressions(wrappedPredicate.getExpressions(), wrappedPredicate.nodeBuilder());
    }

    private static List<ExpressionImplementor<Boolean>> negateCompoundExpressions(List<Expression<Boolean>> expressions, CriteriaNodeBuilder criteriaBuilder) {
        if (expressions == null || expressions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExpressionImplementor<Boolean>> negatedExpressions = new ArrayList<ExpressionImplementor<Boolean>>();
        for (Expression<Boolean> expression : expressions) {
            if (expression instanceof PredicateImplementor) {
                negatedExpressions.add(((PredicateImplementor)expression).not());
                continue;
            }
            negatedExpressions.add((ExpressionImplementor<Boolean>)((Object)criteriaBuilder.not((Expression)expression)));
        }
        return negatedExpressions;
    }

    public Predicate.BooleanOperator getOperator() {
        return this.negatedOperator;
    }

    @Override
    public boolean isNegated() {
        return !this.wrappedPredicate.isNegated();
    }

    public PredicateImplementor getWrappedPredicate() {
        return this.wrappedPredicate;
    }

    public List<Expression<Boolean>> getExpressions() {
        return this.negatedExpressions;
    }

    @Override
    public PredicateImplementor not() {
        return new NegatedPredicateWrapper(this);
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitNegatedPredicate(this);
    }
}

