/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import org.hibernate.query.criteria.spi.AbstractExpression;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;

public class NullifExpression<T>
extends AbstractExpression<T> {
    private final ExpressionImplementor<? extends T> primaryExpression;
    private final ExpressionImplementor<? extends T> secondaryExpression;

    public NullifExpression(ExpressionImplementor<? extends T> primaryExpression, ExpressionImplementor<? extends T> secondaryExpression, CriteriaNodeBuilder builder) {
        super(NullifExpression.determineType(primaryExpression, secondaryExpression), builder);
        this.primaryExpression = primaryExpression;
        this.secondaryExpression = secondaryExpression;
    }

    private static <T> Class<T> determineType(ExpressionImplementor<? extends T> ... expressions) {
        for (ExpressionImplementor<T> expressionImplementor : expressions) {
            if (expressionImplementor.getJavaTypeDescriptor() == null) continue;
            return expressionImplementor.getJavaTypeDescriptor().getJavaType();
        }
        return null;
    }

    public ExpressionImplementor<? extends T> getPrimaryExpression() {
        return this.primaryExpression;
    }

    public ExpressionImplementor<? extends T> getSecondaryExpression() {
        return this.secondaryExpression;
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitNullifExpression(this);
    }
}

