/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.spi.AbstractNode;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;
import org.hibernate.query.criteria.spi.PredicateImplementor;
import org.hibernate.query.criteria.spi.RootImplementor;
import org.hibernate.query.criteria.spi.SelectionImplementor;
import org.hibernate.query.criteria.spi.SortSpecification;

public class QueryStructure<T>
extends AbstractNode
implements JpaQueryStructure<T> {
    private boolean distinct;
    private SelectionImplementor<T> selection;
    private final Set<RootImplementor<?>> roots = new LinkedHashSet();
    private PredicateImplementor restriction;
    private List<SortSpecification> sortSpecifications;
    private List<ExpressionImplementor<?>> grouping;
    private PredicateImplementor having;
    private ExpressionImplementor limit;
    private ExpressionImplementor offset;

    public QueryStructure(CriteriaNodeBuilder builder) {
        super(builder);
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitQueryStructure(this);
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public QueryStructure setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Override
    public SelectionImplementor<T> getSelection() {
        return this.selection;
    }

    @Override
    public QueryStructure setSelection(JpaSelection<T> selection) {
        return this.setSelection((SelectionImplementor)selection);
    }

    public QueryStructure setSelection(SelectionImplementor<T> selection) {
        this.selection = selection;
        return this;
    }

    @Override
    public Set<? extends RootImplementor<?>> getRoots() {
        return this.roots;
    }

    @Override
    public QueryStructure addRoot(JpaRoot<?> root) {
        return this.addRoot((RootImplementor)root);
    }

    public QueryStructure addRoot(RootImplementor<?> root) {
        this.roots.add(root);
        return this;
    }

    @Override
    public PredicateImplementor getRestriction() {
        return this.restriction;
    }

    public void visitRestriction(Consumer<PredicateImplementor> consumer) {
        if (this.restriction != null) {
            consumer.accept(this.restriction);
        }
    }

    @Override
    public QueryStructure<T> setRestriction(JpaPredicate restriction) {
        this.restriction = (PredicateImplementor)restriction;
        return this;
    }

    @Override
    public QueryStructure<T> setRestriction(Expression<Boolean> restriction) {
        this.restriction = this.nodeBuilder().wrap((Expression)restriction);
        return this;
    }

    @Override
    public QueryStructure<T> setRestriction(Predicate ... restrictions) {
        this.restriction = this.nodeBuilder().wrap((Expression[])restrictions);
        return this;
    }

    @Override
    public List<? extends ExpressionImplementor<?>> getGroupingExpressions() {
        return this.grouping;
    }

    @Override
    public QueryStructure<T> setGroupingExpressions(List<? extends JpaExpression<?>> grouping) {
        this.grouping = grouping;
        return this;
    }

    @Override
    public QueryStructure<T> setGroupingExpressions(JpaExpression<?> ... grouping) {
        return null;
    }

    @Override
    public PredicateImplementor getGroupRestriction() {
        return this.having;
    }

    @Override
    public QueryStructure<T> setGroupRestriction(JpaPredicate restrictions) {
        this.having = (PredicateImplementor)restrictions;
        return this;
    }

    @Override
    public QueryStructure<T> setGroupRestriction(Expression<Boolean> restriction) {
        this.having = this.nodeBuilder().wrap((Expression)restriction);
        return this;
    }

    @Override
    public QueryStructure<T> setGroupRestriction(Predicate ... restrictions) {
        this.having = this.nodeBuilder().wrap((Expression[])restrictions);
        return this;
    }

    @Override
    public List<? extends SortSpecification> getSortSpecifications() {
        return NullnessHelper.coalesce(this.sortSpecifications, Collections.emptyList());
    }

    public void visitSortSpecifications(Consumer<SortSpecification> sortSpec) {
        if (this.sortSpecifications != null) {
            this.sortSpecifications.forEach(sortSpec);
        }
    }

    @Override
    public QueryStructure<T> setSortSpecifications(List<? extends JpaOrder> sortSpecifications) {
        this.sortSpecifications = sortSpecifications;
        return this;
    }

    @Override
    public <X> ExpressionImplementor<X> getLimit() {
        return this.limit;
    }

    @Override
    public QueryStructure<T> setLimit(JpaExpression<?> limit) {
        this.limit = (ExpressionImplementor)limit;
        return this;
    }

    @Override
    public <X> ExpressionImplementor<X> getOffset() {
        return this.offset;
    }

    @Override
    public QueryStructure<T> setOffset(JpaExpression offset) {
        this.offset = (ExpressionImplementor)offset;
        return this;
    }
}

