/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.query.criteria.JpaSearchedCase;
import org.hibernate.query.criteria.spi.AbstractExpression;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;
import org.hibernate.query.criteria.spi.LiteralExpression;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class SearchedCase<T>
extends AbstractExpression<T>
implements JpaSearchedCase<T> {
    private List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    private ExpressionImplementor<? extends T> otherwiseResult;

    public SearchedCase(CriteriaNodeBuilder criteriaBuilder) {
        super((JavaTypeDescriptor)null, criteriaBuilder);
    }

    public SearchedCase(Class<T> javaType, CriteriaNodeBuilder criteriaBuilder) {
        super(javaType, criteriaBuilder);
    }

    @Override
    public SearchedCase<T> when(Expression<Boolean> condition, T result) {
        return this.when((Expression)condition, this.buildLiteral(result));
    }

    private LiteralExpression<T> buildLiteral(T result) {
        Class<Object> type = result != null ? result.getClass() : this.getJavaType();
        return new LiteralExpression(type, result, this.nodeBuilder());
    }

    @Override
    public SearchedCase<T> when(Expression<Boolean> condition, Expression<? extends T> result) {
        WhenClause whenClause = new WhenClause((ExpressionImplementor)condition, (ExpressionImplementor)result);
        this.whenClauses.add(whenClause);
        this.setJavaType(result.getJavaType());
        return this;
    }

    @Override
    public ExpressionImplementor<T> otherwise(T result) {
        return this.otherwise(this.buildLiteral(result));
    }

    @Override
    public ExpressionImplementor<T> otherwise(Expression<? extends T> result) {
        this.otherwiseResult = (ExpressionImplementor)result;
        this.setJavaType(result.getJavaType());
        return this;
    }

    public ExpressionImplementor<? extends T> getOtherwiseResult() {
        return this.otherwiseResult;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitSearchedCase(this);
    }

    public class WhenClause {
        private final ExpressionImplementor<Boolean> condition;
        private final ExpressionImplementor<? extends T> result;

        public WhenClause(ExpressionImplementor<Boolean> condition, ExpressionImplementor<? extends T> result) {
            this.condition = condition;
            this.result = result;
        }

        public ExpressionImplementor<Boolean> getCondition() {
            return this.condition;
        }

        public ExpressionImplementor<? extends T> getResult() {
            return this.result;
        }
    }
}

