/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.query.criteria.JpaSimpleCase;
import org.hibernate.query.criteria.spi.AbstractExpression;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;
import org.hibernate.query.criteria.spi.LiteralExpression;

public class SimpleCase<C, R>
extends AbstractExpression<R>
implements JpaSimpleCase<C, R> {
    private final ExpressionImplementor<? extends C> expression;
    private List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    private ExpressionImplementor<? extends R> otherwiseResult;

    public SimpleCase(ExpressionImplementor<? extends C> expression, CriteriaNodeBuilder nodeBuilder) {
        super(expression.getJavaTypeDescriptor(), nodeBuilder);
        this.expression = expression;
    }

    public SimpleCase(Class<R> javaType, ExpressionImplementor<? extends C> expression, CriteriaNodeBuilder nodeBuilder) {
        super(javaType, nodeBuilder);
        this.expression = expression;
    }

    @Override
    public ExpressionImplementor<C> getExpression() {
        return this.expression;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    public ExpressionImplementor<? extends R> getOtherwiseResult() {
        return this.otherwiseResult;
    }

    @Override
    public JpaSimpleCase<C, R> when(C condition, R result) {
        return this.when((Object)condition, this.buildLiteral(result));
    }

    private LiteralExpression<R> buildLiteral(R result) {
        Class<Object> type = result != null ? result.getClass() : this.getJavaType();
        return new LiteralExpression(type, result, this.nodeBuilder());
    }

    @Override
    public JpaSimpleCase<C, R> when(C condition, Expression<? extends R> result) {
        WhenClause whenClause = new WhenClause(new LiteralExpression<C>(condition, this.nodeBuilder()), (ExpressionImplementor)result);
        this.whenClauses.add(whenClause);
        this.setJavaType(result.getJavaType());
        return this;
    }

    @Override
    public JpaSimpleCase<C, R> otherwise(R result) {
        return this.otherwise(this.buildLiteral(result));
    }

    @Override
    public JpaSimpleCase<C, R> otherwise(Expression<? extends R> result) {
        this.otherwiseResult = (ExpressionImplementor)result;
        this.setJavaType(result.getJavaType());
        return this;
    }

    public <V> V accept(CriteriaVisitor visitor) {
        return (V)visitor.visitSimpleCase(this);
    }

    public class WhenClause {
        private final LiteralExpression<C> condition;
        private final ExpressionImplementor<? extends R> result;

        WhenClause(LiteralExpression<C> condition, ExpressionImplementor<? extends R> result) {
            this.condition = condition;
            this.result = result;
        }

        public LiteralExpression<C> getCondition() {
            return this.condition;
        }

        public ExpressionImplementor<? extends R> getResult() {
            return this.result;
        }
    }
}

