/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import org.hibernate.NullPrecedence;
import org.hibernate.SortOrder;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.spi.AbstractNode;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;

public class SortSpecification
extends AbstractNode
implements JpaOrder {
    private final ExpressionImplementor sortExpression;
    private SortOrder sortOrder;
    private NullPrecedence nullPrecedence;

    public SortSpecification(ExpressionImplementor sortExpression, CriteriaNodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.sortExpression = sortExpression;
    }

    public SortSpecification(ExpressionImplementor sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence, CriteriaNodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.sortExpression = sortExpression;
        this.sortOrder = sortOrder;
        this.nullPrecedence = nullPrecedence;
    }

    @Override
    public JpaExpression<?> getExpression() {
        return this.sortExpression;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public NullPrecedence getNullPrecedence() {
        return this.nullPrecedence;
    }

    @Override
    public SortSpecification nullPrecedence(NullPrecedence precedence) {
        this.nullPrecedence = precedence;
        return this;
    }

    @Override
    public SortSpecification reverse() {
        this.sortOrder = this.sortOrder.reverse();
        return this;
    }

    public boolean isAscending() {
        return this.sortOrder == SortOrder.ASCENDING;
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitSortSpecification(this);
    }
}

