/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.spi;

import java.util.Collection;
import java.util.Map;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.criteria.PathException;
import org.hibernate.query.criteria.spi.AbstractPath;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.criteria.spi.CriteriaVisitor;
import org.hibernate.query.criteria.spi.ExpressionImplementor;
import org.hibernate.query.criteria.spi.PathImplementor;
import org.hibernate.query.criteria.spi.PathSourceImplementor;

public class TreatedPath<T>
extends AbstractPath<T> {
    private final PathImplementor<? super T> wrappedPath;
    private final EntityTypeDescriptor<T> treatType;

    public TreatedPath(PathImplementor<? super T> wrappedPath, EntityTypeDescriptor<T> treatType, CriteriaNodeBuilder nodeBuilder) {
        super(treatType, (PathSourceImplementor<?>)wrappedPath.getSource(), nodeBuilder);
        this.wrappedPath = wrappedPath;
        this.treatType = treatType;
    }

    public PathImplementor<? super T> getWrappedPath() {
        return this.wrappedPath;
    }

    public EntityTypeDescriptor<T> getTreatType() {
        return this.treatType;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.wrappedPath.getNavigablePath();
    }

    @Override
    public <X> PathSourceImplementor<X> getSource() {
        return this.wrappedPath.getSource();
    }

    @Override
    public PathSourceImplementor asPathSource(String name) throws PathException {
        return this.wrappedPath.asPathSource(name);
    }

    @Override
    public PathImplementor treatAs(Class treatJavaType) throws PathException {
        EntityTypeDescriptor treatTypeDescriptor = this.nodeBuilder().getSessionFactory().getMetamodel().getEntityDescriptor(treatJavaType);
        return new TreatedPath<T>(this.wrappedPath, treatTypeDescriptor, this.nodeBuilder());
    }

    public Bindable<T> getModel() {
        return this.treatType;
    }

    protected PathImplementor getWrappedPathDetyped() {
        return this.wrappedPath;
    }

    @Override
    public <Y> PathImplementor<Y> get(String attributeName) {
        return this.getWrappedPathDetyped().get(attributeName);
    }

    @Override
    public <Y> PathImplementor<Y> get(SingularAttribute<? super T, Y> attribute) {
        return this.getWrappedPathDetyped().get((SingularAttribute)attribute);
    }

    @Override
    public <E, C extends Collection<E>> ExpressionImplementor<C> get(PluralAttribute<T, C, E> collection) {
        return this.getWrappedPathDetyped().get((PluralAttribute)collection);
    }

    @Override
    public <K, V, M extends Map<K, V>> ExpressionImplementor<M> get(MapAttribute<T, K, V> map) {
        return this.getWrappedPathDetyped().get((MapAttribute)map);
    }

    @Override
    public <R> R accept(CriteriaVisitor visitor) {
        return (R)visitor.visitTreatedPath(this);
    }
}

