/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.sqm;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.spi.BaseCriteriaVisitor;
import org.hibernate.query.criteria.spi.ComparisonPredicate;
import org.hibernate.query.criteria.spi.CompoundSelection;
import org.hibernate.query.criteria.spi.ConstructorSelection;
import org.hibernate.query.criteria.spi.FromImplementor;
import org.hibernate.query.criteria.spi.LiteralExpression;
import org.hibernate.query.criteria.spi.ParameterExpression;
import org.hibernate.query.criteria.spi.QueryStructure;
import org.hibernate.query.criteria.spi.RootImplementor;
import org.hibernate.query.criteria.spi.RootQuery;
import org.hibernate.query.criteria.sqm.JpaParameterSqmWrapper;
import org.hibernate.query.sqm.produce.internal.UniqueIdGenerator;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmNavigableJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.internal.ParameterCollector;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;

public class CriteriaQueryToSqmTransformer
extends BaseCriteriaVisitor {
    private final SessionFactoryImplementor sessionFactory;
    private final UniqueIdGenerator uidGenerator = new UniqueIdGenerator();
    private Map<NavigablePath, Set<SqmNavigableJoin>> fetchedJoinsByParentPath;
    private Map<ParameterExpression<?>, SqmParameter> parameterExpressionMap;
    private ParameterCollector parameterCollector;
    private boolean multiValuedParameterBindingsAllowed = false;
    private final Map<FromImplementor<?, ?>, SqmFrom> fromElementMapping = new IdentityHashMap();

    public static <R> SqmSelectStatement transform(RootQuery<R> query, SessionFactoryImplementor sessionFactory) {
        CriteriaQueryToSqmTransformer me = new CriteriaQueryToSqmTransformer(sessionFactory);
        return me.visitRootQuery(query);
    }

    protected CriteriaQueryToSqmTransformer(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSelectStatement visitRootQuery(RootQuery criteriaQuery) {
        SqmSelectStatement sqmSelectStatement = new SqmSelectStatement();
        this.parameterCollector = sqmSelectStatement;
        try {
            sqmSelectStatement.setQuerySpec((SqmQuerySpec)this.visitQueryStructure((QueryStructure)criteriaQuery.getQueryStructure()));
            sqmSelectStatement.applyFetchJoinsByParentPath(this.fetchedJoinsByParentPath);
            SqmSelectStatement sqmSelectStatement2 = sqmSelectStatement;
            return sqmSelectStatement2;
        }
        finally {
            this.parameterCollector = null;
        }
    }

    @Override
    public SqmQuerySpec visitQueryStructure(QueryStructure<?> queryStructure) {
        SqmQuerySpec sqmQuerySpec = new SqmQuerySpec();
        sqmQuerySpec.setFromClause((SqmFromClause)this.visitFromClause((QueryStructure)queryStructure));
        sqmQuerySpec.setSelectClause((SqmSelectClause)this.visitSelectClause((QueryStructure)queryStructure));
        sqmQuerySpec.setWhereClause((SqmWhereClause)this.visitWhereClause((QueryStructure)queryStructure));
        return sqmQuerySpec;
    }

    @Override
    protected SqmFromClause visitFromClause(QueryStructure<?> querySpec) {
        SqmFromClause sqmFromClause = new SqmFromClause();
        for (RootImplementor<?> root : querySpec.getRoots()) {
            SqmRoot sqmRoot = new SqmRoot((EntityTypeDescriptor)root.getModel(), root.getAlias());
            sqmFromClause.addRoot(sqmRoot);
            this.fromElementMapping.put(root, sqmRoot);
            this.consumeJoins(root, sqmRoot);
        }
        return sqmFromClause;
    }

    private void consumeJoins(FromImplementor<?, ?> fromImplementor, SqmFrom sqmFrom) {
        fromImplementor.visitJoins(join -> sqmFrom.addJoin((SqmJoin)join.accept(this)));
        fromImplementor.visitFetches(join -> sqmFrom.addJoin((SqmJoin)join.accept(this)));
    }

    @Override
    public SqmRoot visitRoot(RootImplementor<?> root) {
        return (SqmRoot)this.fromElementMapping.get(root);
    }

    @Override
    protected SqmSelectClause visitSelectClause(QueryStructure<?> querySpec) {
        SqmSelectClause sqmSelectClause = new SqmSelectClause(querySpec.isDistinct());
        JpaSelection criteriaSelection = querySpec.getSelection();
        if (criteriaSelection instanceof ConstructorSelection) {
            Object sqmDynamicInstantiation = this.visitDynamicInstantiation((ConstructorSelection)criteriaSelection);
            sqmSelectClause.addSelection(new SqmSelection((SqmSelectableNode)sqmDynamicInstantiation, criteriaSelection.getAlias()));
        } else if (criteriaSelection instanceof CompoundSelection) {
            ((CompoundSelection)criteriaSelection).getSelectionItems().forEach(item -> sqmSelectClause.addSelection(new SqmSelection((SqmSelectableNode)item.accept(this), item.getAlias())));
        } else {
            sqmSelectClause.addSelection(new SqmSelection((SqmSelectableNode)criteriaSelection.accept(this), criteriaSelection.getAlias()));
        }
        return sqmSelectClause;
    }

    @Override
    public SqmDynamicInstantiation visitDynamicInstantiation(ConstructorSelection<?> selection) {
        SqmDynamicInstantiation result = selection.getJavaType().equals(List.class) ? SqmDynamicInstantiation.forListInstantiation(this.sessionFactory.getTypeConfiguration().getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(List.class)) : (selection.getJavaType().equals(Map.class) ? SqmDynamicInstantiation.forMapInstantiation(this.sessionFactory.getTypeConfiguration().getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(Map.class)) : SqmDynamicInstantiation.forClassInstantiation(selection.getJavaTypeDescriptor()));
        selection.getSelectionItems().forEach(item -> result.addArgument(new SqmDynamicInstantiationArgument((SqmSelectableNode)item.accept(this), item.getAlias())));
        return result;
    }

    @Override
    public SqmLiteral visitLiteral(LiteralExpression<?> expression) {
        return new SqmLiteral(expression.getValue(), this.sessionFactory.getTypeConfiguration().standardExpressableTypeForJavaType(expression.getJavaType()));
    }

    @Override
    public SqmParameter visitParameter(ParameterExpression<?> expression) {
        if (this.parameterExpressionMap != null) {
            SqmParameter existing = this.parameterExpressionMap.get(expression);
            if (existing != null) {
                return existing;
            }
        } else {
            this.parameterExpressionMap = new IdentityHashMap();
        }
        JpaParameterSqmWrapper sqmParam = new JpaParameterSqmWrapper(expression, this.multiValuedParameterBindingsAllowed);
        this.parameterExpressionMap.put(expression, sqmParam);
        this.parameterCollector.addParameter(sqmParam);
        return sqmParam;
    }

    @Override
    protected SqmWhereClause visitWhereClause(QueryStructure<?> querySpec) {
        SqmWhereClause sqmWhereClause = new SqmWhereClause();
        querySpec.visitRestriction(predicate -> sqmWhereClause.setPredicate((SqmPredicate)predicate.accept(this)));
        return sqmWhereClause;
    }

    @Override
    public SqmPredicate visitComparisonPredicate(ComparisonPredicate predicate) {
        return new SqmComparisonPredicate((SqmExpression)predicate.getLeftHandOperand().accept(this), predicate.getComparisonOperator(), (SqmExpression)predicate.getLeftHandOperand().accept(this));
    }
}

